/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisShiftResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisGetEmployeeShiftResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends HrisShiftResult> hrisShiftResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisGetEmployeeShiftResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends HrisShiftResult> hrisShiftResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisShiftResult, "hrisShiftResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisShiftResult = hrisShiftResult;
        this.headers = headers;
    }

    public HrisGetEmployeeShiftResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<HrisShiftResult> hrisShiftResult() {
        return this.hrisShiftResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisGetEmployeeShiftResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisGetEmployeeShiftResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisGetEmployeeShiftResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisGetEmployeeShiftResponse withHrisShiftResult(HrisShiftResult hrisShiftResult) {
        Utils.checkNotNull(hrisShiftResult, "hrisShiftResult");
        this.hrisShiftResult = Optional.ofNullable(hrisShiftResult);
        return this;
    }

    public HrisGetEmployeeShiftResponse withHrisShiftResult(Optional<? extends HrisShiftResult> hrisShiftResult) {
        Utils.checkNotNull(hrisShiftResult, "hrisShiftResult");
        this.hrisShiftResult = hrisShiftResult;
        return this;
    }

    public HrisGetEmployeeShiftResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisGetEmployeeShiftResponse other = (HrisGetEmployeeShiftResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.hrisShiftResult, other.hrisShiftResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.hrisShiftResult, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisGetEmployeeShiftResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "hrisShiftResult", this.hrisShiftResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends HrisShiftResult> hrisShiftResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder hrisShiftResult(HrisShiftResult hrisShiftResult) {
            Utils.checkNotNull(hrisShiftResult, "hrisShiftResult");
            this.hrisShiftResult = Optional.ofNullable(hrisShiftResult);
            return this;
        }

        public Builder hrisShiftResult(Optional<? extends HrisShiftResult> hrisShiftResult) {
            Utils.checkNotNull(hrisShiftResult, "hrisShiftResult");
            this.hrisShiftResult = hrisShiftResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisGetEmployeeShiftResponse build() {
            return new HrisGetEmployeeShiftResponse(this.contentType, this.statusCode, this.rawResponse, this.hrisShiftResult, this.headers);
        }
    }
}

