/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.utils.LazySingletonValue;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class ActionBuildDto {
    /**
     * Specific connector key to rebuild embeddings for
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("connector_key")
    private Optional<String> connectorKey;

    /**
     * Force refresh - clear all existing embeddings before rebuilding
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("force_refresh")
    private Optional<Boolean> forceRefresh;

    @JsonCreator
    public ActionBuildDto(
            @JsonProperty("connector_key") Optional<String> connectorKey,
            @JsonProperty("force_refresh") Optional<Boolean> forceRefresh) {
        Utils.checkNotNull(connectorKey, "connectorKey");
        Utils.checkNotNull(forceRefresh, "forceRefresh");
        this.connectorKey = connectorKey;
        this.forceRefresh = forceRefresh;
    }
    
    public ActionBuildDto() {
        this(Optional.empty(), Optional.empty());
    }

    /**
     * Specific connector key to rebuild embeddings for
     */
    @JsonIgnore
    public Optional<String> connectorKey() {
        return connectorKey;
    }

    /**
     * Force refresh - clear all existing embeddings before rebuilding
     */
    @JsonIgnore
    public Optional<Boolean> forceRefresh() {
        return forceRefresh;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Specific connector key to rebuild embeddings for
     */
    public ActionBuildDto withConnectorKey(String connectorKey) {
        Utils.checkNotNull(connectorKey, "connectorKey");
        this.connectorKey = Optional.ofNullable(connectorKey);
        return this;
    }


    /**
     * Specific connector key to rebuild embeddings for
     */
    public ActionBuildDto withConnectorKey(Optional<String> connectorKey) {
        Utils.checkNotNull(connectorKey, "connectorKey");
        this.connectorKey = connectorKey;
        return this;
    }

    /**
     * Force refresh - clear all existing embeddings before rebuilding
     */
    public ActionBuildDto withForceRefresh(boolean forceRefresh) {
        Utils.checkNotNull(forceRefresh, "forceRefresh");
        this.forceRefresh = Optional.ofNullable(forceRefresh);
        return this;
    }


    /**
     * Force refresh - clear all existing embeddings before rebuilding
     */
    public ActionBuildDto withForceRefresh(Optional<Boolean> forceRefresh) {
        Utils.checkNotNull(forceRefresh, "forceRefresh");
        this.forceRefresh = forceRefresh;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ActionBuildDto other = (ActionBuildDto) o;
        return 
            Utils.enhancedDeepEquals(this.connectorKey, other.connectorKey) &&
            Utils.enhancedDeepEquals(this.forceRefresh, other.forceRefresh);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            connectorKey, forceRefresh);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ActionBuildDto.class,
                "connectorKey", connectorKey,
                "forceRefresh", forceRefresh);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Optional<String> connectorKey = Optional.empty();

        private Optional<Boolean> forceRefresh;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Specific connector key to rebuild embeddings for
         */
        public Builder connectorKey(String connectorKey) {
            Utils.checkNotNull(connectorKey, "connectorKey");
            this.connectorKey = Optional.ofNullable(connectorKey);
            return this;
        }

        /**
         * Specific connector key to rebuild embeddings for
         */
        public Builder connectorKey(Optional<String> connectorKey) {
            Utils.checkNotNull(connectorKey, "connectorKey");
            this.connectorKey = connectorKey;
            return this;
        }


        /**
         * Force refresh - clear all existing embeddings before rebuilding
         */
        public Builder forceRefresh(boolean forceRefresh) {
            Utils.checkNotNull(forceRefresh, "forceRefresh");
            this.forceRefresh = Optional.ofNullable(forceRefresh);
            return this;
        }

        /**
         * Force refresh - clear all existing embeddings before rebuilding
         */
        public Builder forceRefresh(Optional<Boolean> forceRefresh) {
            Utils.checkNotNull(forceRefresh, "forceRefresh");
            this.forceRefresh = forceRefresh;
            return this;
        }

        public ActionBuildDto build() {
            if (forceRefresh == null) {
                forceRefresh = _SINGLETON_VALUE_ForceRefresh.value();
            }

            return new ActionBuildDto(
                connectorKey, forceRefresh);
        }


        private static final LazySingletonValue<Optional<Boolean>> _SINGLETON_VALUE_ForceRefresh =
                new LazySingletonValue<>(
                        "force_refresh",
                        "false",
                        new TypeReference<Optional<Boolean>>() {});
    }
}
