/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * AnswerValue
 * 
 * <p>The type of the answer.
 */
public class AnswerValue {

    public static final AnswerValue SHORT_TEXT = new AnswerValue("short_text");
    public static final AnswerValue LONG_TEXT = new AnswerValue("long_text");
    public static final AnswerValue ATTACHMENT = new AnswerValue("attachment");
    public static final AnswerValue MULTI_SELECT = new AnswerValue("multi_select");
    public static final AnswerValue SINGLE_SELECT = new AnswerValue("single_select");
    public static final AnswerValue BOOLEAN = new AnswerValue("boolean");
    public static final AnswerValue NUMBER = new AnswerValue("number");
    public static final AnswerValue DATE = new AnswerValue("date");
    public static final AnswerValue VIDEO = new AnswerValue("video");
    public static final AnswerValue REFERENCE_CHECK = new AnswerValue("reference_check");
    public static final AnswerValue URL = new AnswerValue("url");
    public static final AnswerValue UNMAPPED_VALUE = new AnswerValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AnswerValue> values = createValuesMap();
    private static final Map<String, AnswerValueEnum> enums = createEnumsMap();

    private final String value;

    private AnswerValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AnswerValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AnswerValue
     */ 
    @JsonCreator
    public static AnswerValue of(String value) {
        synchronized (AnswerValue.class) {
            return values.computeIfAbsent(value, v -> new AnswerValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<AnswerValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AnswerValue other = (AnswerValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AnswerValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AnswerValue[] values() {
        synchronized (AnswerValue.class) {
            return values.values().toArray(new AnswerValue[] {});
        }
    }

    private static final Map<String, AnswerValue> createValuesMap() {
        Map<String, AnswerValue> map = new LinkedHashMap<>();
        map.put("short_text", SHORT_TEXT);
        map.put("long_text", LONG_TEXT);
        map.put("attachment", ATTACHMENT);
        map.put("multi_select", MULTI_SELECT);
        map.put("single_select", SINGLE_SELECT);
        map.put("boolean", BOOLEAN);
        map.put("number", NUMBER);
        map.put("date", DATE);
        map.put("video", VIDEO);
        map.put("reference_check", REFERENCE_CHECK);
        map.put("url", URL);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AnswerValueEnum> createEnumsMap() {
        Map<String, AnswerValueEnum> map = new HashMap<>();
        map.put("short_text", AnswerValueEnum.SHORT_TEXT);
        map.put("long_text", AnswerValueEnum.LONG_TEXT);
        map.put("attachment", AnswerValueEnum.ATTACHMENT);
        map.put("multi_select", AnswerValueEnum.MULTI_SELECT);
        map.put("single_select", AnswerValueEnum.SINGLE_SELECT);
        map.put("boolean", AnswerValueEnum.BOOLEAN);
        map.put("number", AnswerValueEnum.NUMBER);
        map.put("date", AnswerValueEnum.DATE);
        map.put("video", AnswerValueEnum.VIDEO);
        map.put("reference_check", AnswerValueEnum.REFERENCE_CHECK);
        map.put("url", AnswerValueEnum.URL);
        map.put("unmapped_value", AnswerValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum AnswerValueEnum {

        SHORT_TEXT("short_text"),
        LONG_TEXT("long_text"),
        ATTACHMENT("attachment"),
        MULTI_SELECT("multi_select"),
        SINGLE_SELECT("single_select"),
        BOOLEAN("boolean"),
        NUMBER("number"),
        DATE("date"),
        VIDEO("video"),
        REFERENCE_CHECK("reference_check"),
        URL("url"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private AnswerValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

