/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * ApplicationChangesValue
 * 
 * <p>The type of change that occurred to the application
 */
public class ApplicationChangesValue {

    public static final ApplicationChangesValue APPLICATION_STATUS = new ApplicationChangesValue("application_status");
    public static final ApplicationChangesValue INTERVIEW_STAGE = new ApplicationChangesValue("interview_stage");
    public static final ApplicationChangesValue REJECTED_REASONS = new ApplicationChangesValue("rejected_reasons");
    public static final ApplicationChangesValue UNMAPPED_VALUE = new ApplicationChangesValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, ApplicationChangesValue> values = createValuesMap();
    private static final Map<String, ApplicationChangesValueEnum> enums = createEnumsMap();

    private final String value;

    private ApplicationChangesValue(String value) {
        this.value = value;
    }

    /**
     * Returns a ApplicationChangesValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as ApplicationChangesValue
     */ 
    @JsonCreator
    public static ApplicationChangesValue of(String value) {
        synchronized (ApplicationChangesValue.class) {
            return values.computeIfAbsent(value, v -> new ApplicationChangesValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<ApplicationChangesValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ApplicationChangesValue other = (ApplicationChangesValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "ApplicationChangesValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static ApplicationChangesValue[] values() {
        synchronized (ApplicationChangesValue.class) {
            return values.values().toArray(new ApplicationChangesValue[] {});
        }
    }

    private static final Map<String, ApplicationChangesValue> createValuesMap() {
        Map<String, ApplicationChangesValue> map = new LinkedHashMap<>();
        map.put("application_status", APPLICATION_STATUS);
        map.put("interview_stage", INTERVIEW_STAGE);
        map.put("rejected_reasons", REJECTED_REASONS);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ApplicationChangesValueEnum> createEnumsMap() {
        Map<String, ApplicationChangesValueEnum> map = new HashMap<>();
        map.put("application_status", ApplicationChangesValueEnum.APPLICATION_STATUS);
        map.put("interview_stage", ApplicationChangesValueEnum.INTERVIEW_STAGE);
        map.put("rejected_reasons", ApplicationChangesValueEnum.REJECTED_REASONS);
        map.put("unmapped_value", ApplicationChangesValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum ApplicationChangesValueEnum {

        APPLICATION_STATUS("application_status"),
        INTERVIEW_STAGE("interview_stage"),
        REJECTED_REASONS("rejected_reasons"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private ApplicationChangesValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

