/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * AssignmentValue
 * 
 * <p>The StackOne unified assignment status.
 */
public class AssignmentValue {

    public static final AssignmentValue PENDING = new AssignmentValue("pending");
    public static final AssignmentValue IN_PROGRESS = new AssignmentValue("in_progress");
    public static final AssignmentValue COMPLETED = new AssignmentValue("completed");
    public static final AssignmentValue UNMAPPED_VALUE = new AssignmentValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AssignmentValue> values = createValuesMap();
    private static final Map<String, AssignmentValueEnum> enums = createEnumsMap();

    private final String value;

    private AssignmentValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AssignmentValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AssignmentValue
     */ 
    @JsonCreator
    public static AssignmentValue of(String value) {
        synchronized (AssignmentValue.class) {
            return values.computeIfAbsent(value, v -> new AssignmentValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<AssignmentValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AssignmentValue other = (AssignmentValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AssignmentValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AssignmentValue[] values() {
        synchronized (AssignmentValue.class) {
            return values.values().toArray(new AssignmentValue[] {});
        }
    }

    private static final Map<String, AssignmentValue> createValuesMap() {
        Map<String, AssignmentValue> map = new LinkedHashMap<>();
        map.put("pending", PENDING);
        map.put("in_progress", IN_PROGRESS);
        map.put("completed", COMPLETED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AssignmentValueEnum> createEnumsMap() {
        Map<String, AssignmentValueEnum> map = new HashMap<>();
        map.put("pending", AssignmentValueEnum.PENDING);
        map.put("in_progress", AssignmentValueEnum.IN_PROGRESS);
        map.put("completed", AssignmentValueEnum.COMPLETED);
        map.put("unmapped_value", AssignmentValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum AssignmentValueEnum {

        PENDING("pending"),
        IN_PROGRESS("in_progress"),
        COMPLETED("completed"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private AssignmentValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

