/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * CategoryLevelValue
 * 
 * <p>The unified category level. For write operations: provide one of the listed enum values, or omit/set
 * to "unmapped_value" to use source_value instead.
 */
public class CategoryLevelValue {

    public static final CategoryLevelValue PRIMARY = new CategoryLevelValue("primary");
    public static final CategoryLevelValue SECONDARY = new CategoryLevelValue("secondary");
    public static final CategoryLevelValue TERTIARY = new CategoryLevelValue("tertiary");
    public static final CategoryLevelValue UNMAPPED_VALUE = new CategoryLevelValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, CategoryLevelValue> values = createValuesMap();
    private static final Map<String, CategoryLevelValueEnum> enums = createEnumsMap();

    private final String value;

    private CategoryLevelValue(String value) {
        this.value = value;
    }

    /**
     * Returns a CategoryLevelValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as CategoryLevelValue
     */ 
    @JsonCreator
    public static CategoryLevelValue of(String value) {
        synchronized (CategoryLevelValue.class) {
            return values.computeIfAbsent(value, v -> new CategoryLevelValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<CategoryLevelValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CategoryLevelValue other = (CategoryLevelValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "CategoryLevelValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static CategoryLevelValue[] values() {
        synchronized (CategoryLevelValue.class) {
            return values.values().toArray(new CategoryLevelValue[] {});
        }
    }

    private static final Map<String, CategoryLevelValue> createValuesMap() {
        Map<String, CategoryLevelValue> map = new LinkedHashMap<>();
        map.put("primary", PRIMARY);
        map.put("secondary", SECONDARY);
        map.put("tertiary", TERTIARY);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CategoryLevelValueEnum> createEnumsMap() {
        Map<String, CategoryLevelValueEnum> map = new HashMap<>();
        map.put("primary", CategoryLevelValueEnum.PRIMARY);
        map.put("secondary", CategoryLevelValueEnum.SECONDARY);
        map.put("tertiary", CategoryLevelValueEnum.TERTIARY);
        map.put("unmapped_value", CategoryLevelValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum CategoryLevelValueEnum {

        PRIMARY("primary"),
        SECONDARY("secondary"),
        TERTIARY("tertiary"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private CategoryLevelValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

