/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * CategoryValue
 * 
 * <p>The unified category level. For write operations: provide one of the listed enum values, or omit/set
 * to "unmapped_value" to use source_value instead.
 */
public class CategoryValue {

    public static final CategoryValue PRIMARY = new CategoryValue("primary");
    public static final CategoryValue SECONDARY = new CategoryValue("secondary");
    public static final CategoryValue TERTIARY = new CategoryValue("tertiary");
    public static final CategoryValue UNMAPPED_VALUE = new CategoryValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, CategoryValue> values = createValuesMap();
    private static final Map<String, CategoryValueEnum> enums = createEnumsMap();

    private final String value;

    private CategoryValue(String value) {
        this.value = value;
    }

    /**
     * Returns a CategoryValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as CategoryValue
     */ 
    @JsonCreator
    public static CategoryValue of(String value) {
        synchronized (CategoryValue.class) {
            return values.computeIfAbsent(value, v -> new CategoryValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<CategoryValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CategoryValue other = (CategoryValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "CategoryValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static CategoryValue[] values() {
        synchronized (CategoryValue.class) {
            return values.values().toArray(new CategoryValue[] {});
        }
    }

    private static final Map<String, CategoryValue> createValuesMap() {
        Map<String, CategoryValue> map = new LinkedHashMap<>();
        map.put("primary", PRIMARY);
        map.put("secondary", SECONDARY);
        map.put("tertiary", TERTIARY);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CategoryValueEnum> createEnumsMap() {
        Map<String, CategoryValueEnum> map = new HashMap<>();
        map.put("primary", CategoryValueEnum.PRIMARY);
        map.put("secondary", CategoryValueEnum.SECONDARY);
        map.put("tertiary", CategoryValueEnum.TERTIARY);
        map.put("unmapped_value", CategoryValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum CategoryValueEnum {

        PRIMARY("primary"),
        SECONDARY("secondary"),
        TERTIARY("tertiary"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private CategoryValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

