/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
public class EmploymentDepartmentValue {

    public static final EmploymentDepartmentValue WORKSPACE = new EmploymentDepartmentValue("workspace");
    public static final EmploymentDepartmentValue TEAM = new EmploymentDepartmentValue("team");
    public static final EmploymentDepartmentValue DEPARTMENT = new EmploymentDepartmentValue("department");
    public static final EmploymentDepartmentValue GROUP = new EmploymentDepartmentValue("group");
    public static final EmploymentDepartmentValue ORGANIZATION = new EmploymentDepartmentValue("organization");
    public static final EmploymentDepartmentValue UNMAPPED_VALUE = new EmploymentDepartmentValue("unmapped_value");
    public static final EmploymentDepartmentValue COST_CENTER = new EmploymentDepartmentValue("cost_center");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, EmploymentDepartmentValue> values = createValuesMap();
    private static final Map<String, EmploymentDepartmentValueEnum> enums = createEnumsMap();

    private final String value;

    private EmploymentDepartmentValue(String value) {
        this.value = value;
    }

    /**
     * Returns a EmploymentDepartmentValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as EmploymentDepartmentValue
     */ 
    @JsonCreator
    public static EmploymentDepartmentValue of(String value) {
        synchronized (EmploymentDepartmentValue.class) {
            return values.computeIfAbsent(value, v -> new EmploymentDepartmentValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<EmploymentDepartmentValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        EmploymentDepartmentValue other = (EmploymentDepartmentValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "EmploymentDepartmentValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static EmploymentDepartmentValue[] values() {
        synchronized (EmploymentDepartmentValue.class) {
            return values.values().toArray(new EmploymentDepartmentValue[] {});
        }
    }

    private static final Map<String, EmploymentDepartmentValue> createValuesMap() {
        Map<String, EmploymentDepartmentValue> map = new LinkedHashMap<>();
        map.put("workspace", WORKSPACE);
        map.put("team", TEAM);
        map.put("department", DEPARTMENT);
        map.put("group", GROUP);
        map.put("organization", ORGANIZATION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("cost_center", COST_CENTER);
        return map;
    }

    private static final Map<String, EmploymentDepartmentValueEnum> createEnumsMap() {
        Map<String, EmploymentDepartmentValueEnum> map = new HashMap<>();
        map.put("workspace", EmploymentDepartmentValueEnum.WORKSPACE);
        map.put("team", EmploymentDepartmentValueEnum.TEAM);
        map.put("department", EmploymentDepartmentValueEnum.DEPARTMENT);
        map.put("group", EmploymentDepartmentValueEnum.GROUP);
        map.put("organization", EmploymentDepartmentValueEnum.ORGANIZATION);
        map.put("unmapped_value", EmploymentDepartmentValueEnum.UNMAPPED_VALUE);
        map.put("cost_center", EmploymentDepartmentValueEnum.COST_CENTER);
        return map;
    }
    
    
    public enum EmploymentDepartmentValueEnum {

        WORKSPACE("workspace"),
        TEAM("team"),
        DEPARTMENT("department"),
        GROUP("group"),
        ORGANIZATION("organization"),
        UNMAPPED_VALUE("unmapped_value"),
        COST_CENTER("cost_center"),;

        private final String value;

        private EmploymentDepartmentValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

