/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
public class HRISDepartmentValue {

    public static final HRISDepartmentValue DEPARTMENT = new HRISDepartmentValue("department");
    public static final HRISDepartmentValue COMPANY = new HRISDepartmentValue("company");
    public static final HRISDepartmentValue DIVISION = new HRISDepartmentValue("division");
    public static final HRISDepartmentValue GROUP = new HRISDepartmentValue("group");
    public static final HRISDepartmentValue PROJECT = new HRISDepartmentValue("project");
    public static final HRISDepartmentValue TEAM = new HRISDepartmentValue("team");
    public static final HRISDepartmentValue UNMAPPED_VALUE = new HRISDepartmentValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, HRISDepartmentValue> values = createValuesMap();
    private static final Map<String, HRISDepartmentValueEnum> enums = createEnumsMap();

    private final String value;

    private HRISDepartmentValue(String value) {
        this.value = value;
    }

    /**
     * Returns a HRISDepartmentValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as HRISDepartmentValue
     */ 
    @JsonCreator
    public static HRISDepartmentValue of(String value) {
        synchronized (HRISDepartmentValue.class) {
            return values.computeIfAbsent(value, v -> new HRISDepartmentValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<HRISDepartmentValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        HRISDepartmentValue other = (HRISDepartmentValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "HRISDepartmentValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static HRISDepartmentValue[] values() {
        synchronized (HRISDepartmentValue.class) {
            return values.values().toArray(new HRISDepartmentValue[] {});
        }
    }

    private static final Map<String, HRISDepartmentValue> createValuesMap() {
        Map<String, HRISDepartmentValue> map = new LinkedHashMap<>();
        map.put("department", DEPARTMENT);
        map.put("company", COMPANY);
        map.put("division", DIVISION);
        map.put("group", GROUP);
        map.put("project", PROJECT);
        map.put("team", TEAM);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, HRISDepartmentValueEnum> createEnumsMap() {
        Map<String, HRISDepartmentValueEnum> map = new HashMap<>();
        map.put("department", HRISDepartmentValueEnum.DEPARTMENT);
        map.put("company", HRISDepartmentValueEnum.COMPANY);
        map.put("division", HRISDepartmentValueEnum.DIVISION);
        map.put("group", HRISDepartmentValueEnum.GROUP);
        map.put("project", HRISDepartmentValueEnum.PROJECT);
        map.put("team", HRISDepartmentValueEnum.TEAM);
        map.put("unmapped_value", HRISDepartmentValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum HRISDepartmentValueEnum {

        DEPARTMENT("department"),
        COMPANY("company"),
        DIVISION("division"),
        GROUP("group"),
        PROJECT("project"),
        TEAM("team"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private HRISDepartmentValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

