/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * ListValue
 * 
 * <p>The type of the list.
 */
public class ListValue {

    public static final ListValue CANDIDATES = new ListValue("candidates");
    public static final ListValue CONTACTS = new ListValue("contacts");
    public static final ListValue COMPANIES = new ListValue("companies");
    public static final ListValue UNMAPPED_VALUE = new ListValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, ListValue> values = createValuesMap();
    private static final Map<String, ListValueEnum> enums = createEnumsMap();

    private final String value;

    private ListValue(String value) {
        this.value = value;
    }

    /**
     * Returns a ListValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as ListValue
     */ 
    @JsonCreator
    public static ListValue of(String value) {
        synchronized (ListValue.class) {
            return values.computeIfAbsent(value, v -> new ListValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<ListValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ListValue other = (ListValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "ListValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static ListValue[] values() {
        synchronized (ListValue.class) {
            return values.values().toArray(new ListValue[] {});
        }
    }

    private static final Map<String, ListValue> createValuesMap() {
        Map<String, ListValue> map = new LinkedHashMap<>();
        map.put("candidates", CANDIDATES);
        map.put("contacts", CONTACTS);
        map.put("companies", COMPANIES);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ListValueEnum> createEnumsMap() {
        Map<String, ListValueEnum> map = new HashMap<>();
        map.put("candidates", ListValueEnum.CANDIDATES);
        map.put("contacts", ListValueEnum.CONTACTS);
        map.put("companies", ListValueEnum.COMPANIES);
        map.put("unmapped_value", ListValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum ListValueEnum {

        CANDIDATES("candidates"),
        CONTACTS("contacts"),
        COMPANIES("companies"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private ListValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

