/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * NoteValue
 * 
 * <p>The visibility of the notes.
 */
public class NoteValue {

    public static final NoteValue PRIVATE = new NoteValue("private");
    public static final NoteValue PUBLIC = new NoteValue("public");
    public static final NoteValue UNMAPPED_VALUE = new NoteValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, NoteValue> values = createValuesMap();
    private static final Map<String, NoteValueEnum> enums = createEnumsMap();

    private final String value;

    private NoteValue(String value) {
        this.value = value;
    }

    /**
     * Returns a NoteValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as NoteValue
     */ 
    @JsonCreator
    public static NoteValue of(String value) {
        synchronized (NoteValue.class) {
            return values.computeIfAbsent(value, v -> new NoteValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<NoteValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        NoteValue other = (NoteValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "NoteValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static NoteValue[] values() {
        synchronized (NoteValue.class) {
            return values.values().toArray(new NoteValue[] {});
        }
    }

    private static final Map<String, NoteValue> createValuesMap() {
        Map<String, NoteValue> map = new LinkedHashMap<>();
        map.put("private", PRIVATE);
        map.put("public", PUBLIC);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, NoteValueEnum> createEnumsMap() {
        Map<String, NoteValueEnum> map = new HashMap<>();
        map.put("private", NoteValueEnum.PRIVATE);
        map.put("public", NoteValueEnum.PUBLIC);
        map.put("unmapped_value", NoteValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum NoteValueEnum {

        PRIVATE("private"),
        PUBLIC("public"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private NoteValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

