/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * PositionValue
 * 
 * <p>The status of the position.
 */
public class PositionValue {

    public static final PositionValue OPEN = new PositionValue("open");
    public static final PositionValue DRAFT = new PositionValue("draft");
    public static final PositionValue CLOSED = new PositionValue("closed");
    public static final PositionValue PAUSED = new PositionValue("paused");
    public static final PositionValue UNMAPPED_VALUE = new PositionValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, PositionValue> values = createValuesMap();
    private static final Map<String, PositionValueEnum> enums = createEnumsMap();

    private final String value;

    private PositionValue(String value) {
        this.value = value;
    }

    /**
     * Returns a PositionValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as PositionValue
     */ 
    @JsonCreator
    public static PositionValue of(String value) {
        synchronized (PositionValue.class) {
            return values.computeIfAbsent(value, v -> new PositionValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<PositionValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        PositionValue other = (PositionValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "PositionValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static PositionValue[] values() {
        synchronized (PositionValue.class) {
            return values.values().toArray(new PositionValue[] {});
        }
    }

    private static final Map<String, PositionValue> createValuesMap() {
        Map<String, PositionValue> map = new LinkedHashMap<>();
        map.put("open", OPEN);
        map.put("draft", DRAFT);
        map.put("closed", CLOSED);
        map.put("paused", PAUSED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, PositionValueEnum> createEnumsMap() {
        Map<String, PositionValueEnum> map = new HashMap<>();
        map.put("open", PositionValueEnum.OPEN);
        map.put("draft", PositionValueEnum.DRAFT);
        map.put("closed", PositionValueEnum.CLOSED);
        map.put("paused", PositionValueEnum.PAUSED);
        map.put("unmapped_value", PositionValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum PositionValueEnum {

        OPEN("open"),
        DRAFT("draft"),
        CLOSED("closed"),
        PAUSED("paused"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private PositionValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

