/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * SkillsLevelValue
 * 
 * <p>The unified skill level. For write operations: provide one of the listed enum values, or omit/set to
 * "unmapped_value" to use source_value instead.
 */
public class SkillsLevelValue {

    public static final SkillsLevelValue PRIMARY = new SkillsLevelValue("primary");
    public static final SkillsLevelValue SECONDARY = new SkillsLevelValue("secondary");
    public static final SkillsLevelValue TERTIARY = new SkillsLevelValue("tertiary");
    public static final SkillsLevelValue UNMAPPED_VALUE = new SkillsLevelValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, SkillsLevelValue> values = createValuesMap();
    private static final Map<String, SkillsLevelValueEnum> enums = createEnumsMap();

    private final String value;

    private SkillsLevelValue(String value) {
        this.value = value;
    }

    /**
     * Returns a SkillsLevelValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as SkillsLevelValue
     */ 
    @JsonCreator
    public static SkillsLevelValue of(String value) {
        synchronized (SkillsLevelValue.class) {
            return values.computeIfAbsent(value, v -> new SkillsLevelValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<SkillsLevelValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SkillsLevelValue other = (SkillsLevelValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "SkillsLevelValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static SkillsLevelValue[] values() {
        synchronized (SkillsLevelValue.class) {
            return values.values().toArray(new SkillsLevelValue[] {});
        }
    }

    private static final Map<String, SkillsLevelValue> createValuesMap() {
        Map<String, SkillsLevelValue> map = new LinkedHashMap<>();
        map.put("primary", PRIMARY);
        map.put("secondary", SECONDARY);
        map.put("tertiary", TERTIARY);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, SkillsLevelValueEnum> createEnumsMap() {
        Map<String, SkillsLevelValueEnum> map = new HashMap<>();
        map.put("primary", SkillsLevelValueEnum.PRIMARY);
        map.put("secondary", SkillsLevelValueEnum.SECONDARY);
        map.put("tertiary", SkillsLevelValueEnum.TERTIARY);
        map.put("unmapped_value", SkillsLevelValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum SkillsLevelValueEnum {

        PRIMARY("primary"),
        SECONDARY("secondary"),
        TERTIARY("tertiary"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private SkillsLevelValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

