/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.MessagingMessageSendRequestDto;
import com.stackone.stackone_client_java.models.operations.MessagingSendMessageRequest;
import com.stackone.stackone_client_java.operations.MessagingSendMessage;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class MessagingSendMessageRequestBuilder {

    private String xAccountId;
    private Optional<String> prefer = Optional.empty();
    private MessagingMessageSendRequestDto messagingMessageSendRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public MessagingSendMessageRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public MessagingSendMessageRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }
                
    public MessagingSendMessageRequestBuilder prefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.of(prefer);
        return this;
    }

    public MessagingSendMessageRequestBuilder prefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public MessagingSendMessageRequestBuilder messagingMessageSendRequestDto(MessagingMessageSendRequestDto messagingMessageSendRequestDto) {
        Utils.checkNotNull(messagingMessageSendRequestDto, "messagingMessageSendRequestDto");
        this.messagingMessageSendRequestDto = messagingMessageSendRequestDto;
        return this;
    }
                
    public MessagingSendMessageRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public MessagingSendMessageRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private MessagingSendMessageRequest buildRequest() {

        MessagingSendMessageRequest request = new MessagingSendMessageRequest(xAccountId,
            prefer,
            messagingMessageSendRequestDto);

        return request;
    }

    public CompletableFuture<MessagingSendMessageResponse> call() {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<MessagingSendMessageRequest, MessagingSendMessageResponse> operation
              = new MessagingSendMessage.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        MessagingSendMessageRequest request = buildRequest();

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }
}
