/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.TicketingTicketUpdateRequestDto;
import com.stackone.stackone_client_java.models.operations.TicketingUpdateTicketRequest;
import com.stackone.stackone_client_java.operations.TicketingUpdateTicket;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class TicketingUpdateTicketRequestBuilder {

    private String xAccountId;
    private String id;
    private Optional<String> prefer = Optional.empty();
    private TicketingTicketUpdateRequestDto ticketingTicketUpdateRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public TicketingUpdateTicketRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public TicketingUpdateTicketRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public TicketingUpdateTicketRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }
                
    public TicketingUpdateTicketRequestBuilder prefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.of(prefer);
        return this;
    }

    public TicketingUpdateTicketRequestBuilder prefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public TicketingUpdateTicketRequestBuilder ticketingTicketUpdateRequestDto(TicketingTicketUpdateRequestDto ticketingTicketUpdateRequestDto) {
        Utils.checkNotNull(ticketingTicketUpdateRequestDto, "ticketingTicketUpdateRequestDto");
        this.ticketingTicketUpdateRequestDto = ticketingTicketUpdateRequestDto;
        return this;
    }
                
    public TicketingUpdateTicketRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public TicketingUpdateTicketRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private TicketingUpdateTicketRequest buildRequest() {

        TicketingUpdateTicketRequest request = new TicketingUpdateTicketRequest(xAccountId,
            id,
            prefer,
            ticketingTicketUpdateRequestDto);

        return request;
    }

    public CompletableFuture<TicketingUpdateTicketResponse> call() {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<TicketingUpdateTicketRequest, TicketingUpdateTicketResponse> operation
              = new TicketingUpdateTicket.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        TicketingUpdateTicketRequest request = buildRequest();

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }
}
