/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CategoryLevelValue {
    public static final CategoryLevelValue PRIMARY = new CategoryLevelValue("primary");
    public static final CategoryLevelValue SECONDARY = new CategoryLevelValue("secondary");
    public static final CategoryLevelValue TERTIARY = new CategoryLevelValue("tertiary");
    public static final CategoryLevelValue UNMAPPED_VALUE = new CategoryLevelValue("unmapped_value");
    private static final Map<String, CategoryLevelValue> values = CategoryLevelValue.createValuesMap();
    private static final Map<String, CategoryLevelValueEnum> enums = CategoryLevelValue.createEnumsMap();
    private final String value;

    private CategoryLevelValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static CategoryLevelValue of(String value) {
        Class<CategoryLevelValue> clazz = CategoryLevelValue.class;
        synchronized (CategoryLevelValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new CategoryLevelValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<CategoryLevelValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CategoryLevelValue other = (CategoryLevelValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "CategoryLevelValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CategoryLevelValue[] values() {
        Class<CategoryLevelValue> clazz = CategoryLevelValue.class;
        synchronized (CategoryLevelValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new CategoryLevelValue[0]);
        }
    }

    private static final Map<String, CategoryLevelValue> createValuesMap() {
        LinkedHashMap<String, CategoryLevelValue> map = new LinkedHashMap<String, CategoryLevelValue>();
        map.put("primary", PRIMARY);
        map.put("secondary", SECONDARY);
        map.put("tertiary", TERTIARY);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CategoryLevelValueEnum> createEnumsMap() {
        HashMap<String, CategoryLevelValueEnum> map = new HashMap<String, CategoryLevelValueEnum>();
        map.put("primary", CategoryLevelValueEnum.PRIMARY);
        map.put("secondary", CategoryLevelValueEnum.SECONDARY);
        map.put("tertiary", CategoryLevelValueEnum.TERTIARY);
        map.put("unmapped_value", CategoryLevelValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum CategoryLevelValueEnum {
        PRIMARY("primary"),
        SECONDARY("secondary"),
        TERTIARY("tertiary"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private CategoryLevelValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

