/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HRISDepartmentValue {
    public static final HRISDepartmentValue DEPARTMENT = new HRISDepartmentValue("department");
    public static final HRISDepartmentValue COMPANY = new HRISDepartmentValue("company");
    public static final HRISDepartmentValue DIVISION = new HRISDepartmentValue("division");
    public static final HRISDepartmentValue GROUP = new HRISDepartmentValue("group");
    public static final HRISDepartmentValue PROJECT = new HRISDepartmentValue("project");
    public static final HRISDepartmentValue TEAM = new HRISDepartmentValue("team");
    public static final HRISDepartmentValue UNMAPPED_VALUE = new HRISDepartmentValue("unmapped_value");
    private static final Map<String, HRISDepartmentValue> values = HRISDepartmentValue.createValuesMap();
    private static final Map<String, HRISDepartmentValueEnum> enums = HRISDepartmentValue.createEnumsMap();
    private final String value;

    private HRISDepartmentValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static HRISDepartmentValue of(String value) {
        Class<HRISDepartmentValue> clazz = HRISDepartmentValue.class;
        synchronized (HRISDepartmentValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new HRISDepartmentValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<HRISDepartmentValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HRISDepartmentValue other = (HRISDepartmentValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "HRISDepartmentValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HRISDepartmentValue[] values() {
        Class<HRISDepartmentValue> clazz = HRISDepartmentValue.class;
        synchronized (HRISDepartmentValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new HRISDepartmentValue[0]);
        }
    }

    private static final Map<String, HRISDepartmentValue> createValuesMap() {
        LinkedHashMap<String, HRISDepartmentValue> map = new LinkedHashMap<String, HRISDepartmentValue>();
        map.put("department", DEPARTMENT);
        map.put("company", COMPANY);
        map.put("division", DIVISION);
        map.put("group", GROUP);
        map.put("project", PROJECT);
        map.put("team", TEAM);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, HRISDepartmentValueEnum> createEnumsMap() {
        HashMap<String, HRISDepartmentValueEnum> map = new HashMap<String, HRISDepartmentValueEnum>();
        map.put("department", HRISDepartmentValueEnum.DEPARTMENT);
        map.put("company", HRISDepartmentValueEnum.COMPANY);
        map.put("division", HRISDepartmentValueEnum.DIVISION);
        map.put("group", HRISDepartmentValueEnum.GROUP);
        map.put("project", HRISDepartmentValueEnum.PROJECT);
        map.put("team", HRISDepartmentValueEnum.TEAM);
        map.put("unmapped_value", HRISDepartmentValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum HRISDepartmentValueEnum {
        DEPARTMENT("department"),
        COMPANY("company"),
        DIVISION("division"),
        GROUP("group"),
        PROJECT("project"),
        TEAM("team"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private HRISDepartmentValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

