/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HrisJobValue {
    public static final HrisJobValue DRAFT = new HrisJobValue("draft");
    public static final HrisJobValue PENDING = new HrisJobValue("pending");
    public static final HrisJobValue ARCHIVED = new HrisJobValue("archived");
    public static final HrisJobValue CLOSED = new HrisJobValue("closed");
    public static final HrisJobValue OPEN = new HrisJobValue("open");
    public static final HrisJobValue DELETED = new HrisJobValue("deleted");
    public static final HrisJobValue UNMAPPED_VALUE = new HrisJobValue("unmapped_value");
    private static final Map<String, HrisJobValue> values = HrisJobValue.createValuesMap();
    private static final Map<String, HrisJobValueEnum> enums = HrisJobValue.createEnumsMap();
    private final String value;

    private HrisJobValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static HrisJobValue of(String value) {
        Class<HrisJobValue> clazz = HrisJobValue.class;
        synchronized (HrisJobValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new HrisJobValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<HrisJobValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HrisJobValue other = (HrisJobValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "HrisJobValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HrisJobValue[] values() {
        Class<HrisJobValue> clazz = HrisJobValue.class;
        synchronized (HrisJobValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new HrisJobValue[0]);
        }
    }

    private static final Map<String, HrisJobValue> createValuesMap() {
        LinkedHashMap<String, HrisJobValue> map = new LinkedHashMap<String, HrisJobValue>();
        map.put("draft", DRAFT);
        map.put("pending", PENDING);
        map.put("archived", ARCHIVED);
        map.put("closed", CLOSED);
        map.put("open", OPEN);
        map.put("deleted", DELETED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, HrisJobValueEnum> createEnumsMap() {
        HashMap<String, HrisJobValueEnum> map = new HashMap<String, HrisJobValueEnum>();
        map.put("draft", HrisJobValueEnum.DRAFT);
        map.put("pending", HrisJobValueEnum.PENDING);
        map.put("archived", HrisJobValueEnum.ARCHIVED);
        map.put("closed", HrisJobValueEnum.CLOSED);
        map.put("open", HrisJobValueEnum.OPEN);
        map.put("deleted", HrisJobValueEnum.DELETED);
        map.put("unmapped_value", HrisJobValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum HrisJobValueEnum {
        DRAFT("draft"),
        PENDING("pending"),
        ARCHIVED("archived"),
        CLOSED("closed"),
        OPEN("open"),
        DELETED("deleted"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private HrisJobValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

