/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PositionValue {
    public static final PositionValue OPEN = new PositionValue("open");
    public static final PositionValue DRAFT = new PositionValue("draft");
    public static final PositionValue CLOSED = new PositionValue("closed");
    public static final PositionValue PAUSED = new PositionValue("paused");
    public static final PositionValue UNMAPPED_VALUE = new PositionValue("unmapped_value");
    private static final Map<String, PositionValue> values = PositionValue.createValuesMap();
    private static final Map<String, PositionValueEnum> enums = PositionValue.createEnumsMap();
    private final String value;

    private PositionValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static PositionValue of(String value) {
        Class<PositionValue> clazz = PositionValue.class;
        synchronized (PositionValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new PositionValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<PositionValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PositionValue other = (PositionValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "PositionValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PositionValue[] values() {
        Class<PositionValue> clazz = PositionValue.class;
        synchronized (PositionValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new PositionValue[0]);
        }
    }

    private static final Map<String, PositionValue> createValuesMap() {
        LinkedHashMap<String, PositionValue> map = new LinkedHashMap<String, PositionValue>();
        map.put("open", OPEN);
        map.put("draft", DRAFT);
        map.put("closed", CLOSED);
        map.put("paused", PAUSED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, PositionValueEnum> createEnumsMap() {
        HashMap<String, PositionValueEnum> map = new HashMap<String, PositionValueEnum>();
        map.put("open", PositionValueEnum.OPEN);
        map.put("draft", PositionValueEnum.DRAFT);
        map.put("closed", PositionValueEnum.CLOSED);
        map.put("paused", PositionValueEnum.PAUSED);
        map.put("unmapped_value", PositionValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum PositionValueEnum {
        OPEN("open"),
        DRAFT("draft"),
        CLOSED("closed"),
        PAUSED("paused"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private PositionValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

