/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsCreateBackgroundCheckOrderRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AtsOrderBackgroundCheckRequestRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private AtsCreateBackgroundCheckOrderRequestDto atsCreateBackgroundCheckOrderRequestDto;

    @JsonCreator
    public AtsOrderBackgroundCheckRequestRequest(String xAccountId, Optional<String> prefer, AtsCreateBackgroundCheckOrderRequestDto atsCreateBackgroundCheckOrderRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(atsCreateBackgroundCheckOrderRequestDto, "atsCreateBackgroundCheckOrderRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.atsCreateBackgroundCheckOrderRequestDto = atsCreateBackgroundCheckOrderRequestDto;
    }

    public AtsOrderBackgroundCheckRequestRequest(String xAccountId, AtsCreateBackgroundCheckOrderRequestDto atsCreateBackgroundCheckOrderRequestDto) {
        this(xAccountId, Optional.empty(), atsCreateBackgroundCheckOrderRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public AtsCreateBackgroundCheckOrderRequestDto atsCreateBackgroundCheckOrderRequestDto() {
        return this.atsCreateBackgroundCheckOrderRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsOrderBackgroundCheckRequestRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsOrderBackgroundCheckRequestRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public AtsOrderBackgroundCheckRequestRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsOrderBackgroundCheckRequestRequest withAtsCreateBackgroundCheckOrderRequestDto(AtsCreateBackgroundCheckOrderRequestDto atsCreateBackgroundCheckOrderRequestDto) {
        Utils.checkNotNull(atsCreateBackgroundCheckOrderRequestDto, "atsCreateBackgroundCheckOrderRequestDto");
        this.atsCreateBackgroundCheckOrderRequestDto = atsCreateBackgroundCheckOrderRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsOrderBackgroundCheckRequestRequest other = (AtsOrderBackgroundCheckRequestRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.atsCreateBackgroundCheckOrderRequestDto, other.atsCreateBackgroundCheckOrderRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.prefer, this.atsCreateBackgroundCheckOrderRequestDto);
    }

    public String toString() {
        return Utils.toString(AtsOrderBackgroundCheckRequestRequest.class, "xAccountId", this.xAccountId, "prefer", this.prefer, "atsCreateBackgroundCheckOrderRequestDto", this.atsCreateBackgroundCheckOrderRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> prefer = Optional.empty();
        private AtsCreateBackgroundCheckOrderRequestDto atsCreateBackgroundCheckOrderRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder atsCreateBackgroundCheckOrderRequestDto(AtsCreateBackgroundCheckOrderRequestDto atsCreateBackgroundCheckOrderRequestDto) {
            Utils.checkNotNull(atsCreateBackgroundCheckOrderRequestDto, "atsCreateBackgroundCheckOrderRequestDto");
            this.atsCreateBackgroundCheckOrderRequestDto = atsCreateBackgroundCheckOrderRequestDto;
            return this;
        }

        public AtsOrderBackgroundCheckRequestRequest build() {
            return new AtsOrderBackgroundCheckRequestRequest(this.xAccountId, this.prefer, this.atsCreateBackgroundCheckOrderRequestDto);
        }
    }
}

