/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ScorecardsResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsGetApplicationScorecardResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends ScorecardsResult> scorecardsResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsGetApplicationScorecardResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends ScorecardsResult> scorecardsResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(scorecardsResult, "scorecardsResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.scorecardsResult = scorecardsResult;
        this.headers = headers;
    }

    public AtsGetApplicationScorecardResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ScorecardsResult> scorecardsResult() {
        return this.scorecardsResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsGetApplicationScorecardResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsGetApplicationScorecardResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsGetApplicationScorecardResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsGetApplicationScorecardResponse withScorecardsResult(ScorecardsResult scorecardsResult) {
        Utils.checkNotNull(scorecardsResult, "scorecardsResult");
        this.scorecardsResult = Optional.ofNullable(scorecardsResult);
        return this;
    }

    public AtsGetApplicationScorecardResponse withScorecardsResult(Optional<? extends ScorecardsResult> scorecardsResult) {
        Utils.checkNotNull(scorecardsResult, "scorecardsResult");
        this.scorecardsResult = scorecardsResult;
        return this;
    }

    public AtsGetApplicationScorecardResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsGetApplicationScorecardResponse other = (AtsGetApplicationScorecardResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.scorecardsResult, other.scorecardsResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.scorecardsResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsGetApplicationScorecardResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "scorecardsResult", this.scorecardsResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends ScorecardsResult> scorecardsResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder scorecardsResult(ScorecardsResult scorecardsResult) {
            Utils.checkNotNull(scorecardsResult, "scorecardsResult");
            this.scorecardsResult = Optional.ofNullable(scorecardsResult);
            return this;
        }

        public Builder scorecardsResult(Optional<? extends ScorecardsResult> scorecardsResult) {
            Utils.checkNotNull(scorecardsResult, "scorecardsResult");
            this.scorecardsResult = scorecardsResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsGetApplicationScorecardResponse build() {
            return new AtsGetApplicationScorecardResponse(this.contentType, this.statusCode, this.rawResponse, this.scorecardsResult, this.headers);
        }
    }
}

