/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ActionSearchResponseDto;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StackoneSearchActionsResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends ActionSearchResponseDto> actionSearchResponseDto;
    private Map<String, List<String>> headers;

    @JsonCreator
    public StackoneSearchActionsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends ActionSearchResponseDto> actionSearchResponseDto, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(actionSearchResponseDto, "actionSearchResponseDto");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.actionSearchResponseDto = actionSearchResponseDto;
        this.headers = headers;
    }

    public StackoneSearchActionsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ActionSearchResponseDto> actionSearchResponseDto() {
        return this.actionSearchResponseDto;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public StackoneSearchActionsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public StackoneSearchActionsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public StackoneSearchActionsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public StackoneSearchActionsResponse withActionSearchResponseDto(ActionSearchResponseDto actionSearchResponseDto) {
        Utils.checkNotNull(actionSearchResponseDto, "actionSearchResponseDto");
        this.actionSearchResponseDto = Optional.ofNullable(actionSearchResponseDto);
        return this;
    }

    public StackoneSearchActionsResponse withActionSearchResponseDto(Optional<? extends ActionSearchResponseDto> actionSearchResponseDto) {
        Utils.checkNotNull(actionSearchResponseDto, "actionSearchResponseDto");
        this.actionSearchResponseDto = actionSearchResponseDto;
        return this;
    }

    public StackoneSearchActionsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackoneSearchActionsResponse other = (StackoneSearchActionsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.actionSearchResponseDto, other.actionSearchResponseDto) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.actionSearchResponseDto, this.headers);
    }

    public String toString() {
        return Utils.toString(StackoneSearchActionsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "actionSearchResponseDto", this.actionSearchResponseDto, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends ActionSearchResponseDto> actionSearchResponseDto = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder actionSearchResponseDto(ActionSearchResponseDto actionSearchResponseDto) {
            Utils.checkNotNull(actionSearchResponseDto, "actionSearchResponseDto");
            this.actionSearchResponseDto = Optional.ofNullable(actionSearchResponseDto);
            return this;
        }

        public Builder actionSearchResponseDto(Optional<? extends ActionSearchResponseDto> actionSearchResponseDto) {
            Utils.checkNotNull(actionSearchResponseDto, "actionSearchResponseDto");
            this.actionSearchResponseDto = actionSearchResponseDto;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public StackoneSearchActionsResponse build() {
            return new StackoneSearchActionsResponse(this.contentType, this.statusCode, this.rawResponse, this.actionSearchResponseDto, this.headers);
        }
    }
}

