/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils.reactive;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public final class ReactiveUtils {
    private ReactiveUtils() {
    }

    public static <T, R> Flow.Publisher<R> mapAsync(Flow.Publisher<T> source, Function<T, CompletableFuture<R>> mapper) {
        Objects.requireNonNull(source, "Source publisher cannot be null");
        Objects.requireNonNull(mapper, "Mapper function cannot be null");
        return new AsyncMappingPublisher<T, R>(source, mapper);
    }

    public static <T, R> Flow.Publisher<R> map(Flow.Publisher<T> source, Function<T, R> mapper) {
        Objects.requireNonNull(source, "Source publisher cannot be null");
        Objects.requireNonNull(mapper, "Mapper function cannot be null");
        return new SyncMappingPublisher<T, R>(source, mapper);
    }

    public static <T, R> Flow.Publisher<R> flatten(Flow.Publisher<T> source, Function<T, Iterable<R>> flattener) {
        Objects.requireNonNull(source, "Source publisher cannot be null");
        Objects.requireNonNull(flattener, "Flattener function cannot be null");
        return new FlatteningPublisher<T, R>(source, flattener);
    }

    public static <T> Flow.Publisher<T> flatten(Flow.Publisher<List<T>> source) {
        return ReactiveUtils.flatten(source, list -> list);
    }

    public static <T> Flow.Publisher<List<T>> wrapped(Flow.Publisher<T> source) {
        return new SyncMappingPublisher<Object, List>(source, List::of);
    }

    public static <T> Flow.Publisher<T> concat(List<Flow.Publisher<T>> pubs) {
        return new ConcatPublisher<T>(pubs);
    }

    private static final class ConcatSubscription<T>
    implements Flow.Subscription {
        private final Flow.Subscriber<T> downstream;
        private final Iterator<Flow.Publisher<T>> it;
        private Flow.Subscription upstream;
        private long demand = 0L;
        private boolean cancelled = false;
        private boolean completed = false;

        public ConcatSubscription(Flow.Subscriber<T> downstream, Iterator<Flow.Publisher<T>> it) {
            this.downstream = downstream;
            this.it = it;
        }

        @Override
        public synchronized void request(long n) {
            if (this.cancelled || this.completed || n <= 0L) {
                return;
            }
            this.demand = ConcatSubscription.addCap(this.demand, n);
            if (this.upstream == null) {
                this.subscribeNext();
            } else {
                this.upstream.request(n);
            }
        }

        @Override
        public synchronized void cancel() {
            this.cancelled = true;
            if (this.upstream != null) {
                this.upstream.cancel();
            }
        }

        private void subscribeNext() {
            if (this.cancelled) {
                return;
            }
            if (!this.it.hasNext()) {
                this.completed = true;
                this.downstream.onComplete();
                return;
            }
            Flow.Publisher<T> next = this.it.next();
            next.subscribe(new Upstream());
        }

        private static long addCap(long a, long b) {
            long r = a + b;
            return r < 0L ? Long.MAX_VALUE : r;
        }

        private final class Upstream
        implements Flow.Subscriber<T> {
            private Upstream() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSubscribe(Flow.Subscription s) {
                ConcatSubscription concatSubscription = ConcatSubscription.this;
                synchronized (concatSubscription) {
                    ConcatSubscription.this.upstream = s;
                    if (ConcatSubscription.this.demand > 0L) {
                        s.request(ConcatSubscription.this.demand);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T item) {
                ConcatSubscription concatSubscription = ConcatSubscription.this;
                synchronized (concatSubscription) {
                    if (ConcatSubscription.this.demand == 0L) {
                        return;
                    }
                    --ConcatSubscription.this.demand;
                    long afterDecrement = ConcatSubscription.this.demand;
                }
                ConcatSubscription.this.downstream.onNext(item);
            }

            @Override
            public void onError(Throwable t) {
                ConcatSubscription.this.downstream.onError(t);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onComplete() {
                ConcatSubscription concatSubscription = ConcatSubscription.this;
                synchronized (concatSubscription) {
                    ConcatSubscription.this.upstream = null;
                    if (ConcatSubscription.this.cancelled) {
                        return;
                    }
                }
                ConcatSubscription.this.subscribeNext();
            }
        }
    }

    private static class FlatteningSubscriber<T, R>
    implements Flow.Subscriber<T> {
        private final Flow.Subscriber<? super R> downstream;
        private final Function<T, Iterable<R>> flattener;
        private Flow.Subscription upstreamSubscription;
        private volatile boolean cancelled = false;

        public FlatteningSubscriber(Flow.Subscriber<? super R> downstream, Function<T, Iterable<R>> flattener) {
            this.downstream = Objects.requireNonNull(downstream, "Downstream subscriber cannot be null");
            this.flattener = flattener;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.upstreamSubscription = Objects.requireNonNull(subscription, "Upstream subscription cannot be null");
            this.downstream.onSubscribe(new Flow.Subscription(){

                @Override
                public void request(long n) {
                    if (n <= 0L) {
                        downstream.onError(new IllegalArgumentException("Demand must be positive: " + n));
                        return;
                    }
                    if (!cancelled && upstreamSubscription != null) {
                        upstreamSubscription.request(n);
                    }
                }

                @Override
                public void cancel() {
                    cancelled = true;
                    if (upstreamSubscription != null) {
                        upstreamSubscription.cancel();
                    }
                }
            });
        }

        @Override
        public void onNext(T item) {
            block5: {
                if (this.cancelled) {
                    return;
                }
                try {
                    Iterable<R> items = this.flattener.apply(item);
                    for (R flattenedItem : items) {
                        if (!this.cancelled) {
                            this.downstream.onNext(flattenedItem);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    if (this.cancelled) break block5;
                    this.cancelled = true;
                    this.upstreamSubscription.cancel();
                    this.downstream.onError(e);
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (!this.cancelled) {
                this.downstream.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (!this.cancelled) {
                this.downstream.onComplete();
            }
        }
    }

    private static class SyncMappingSubscriber<T, R>
    implements Flow.Subscriber<T> {
        private final Flow.Subscriber<? super R> downstream;
        private final Function<T, R> mapper;
        private Flow.Subscription upstream;
        private volatile boolean cancelled = false;

        public SyncMappingSubscriber(Flow.Subscriber<? super R> downstream, Function<T, R> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.upstream = subscription;
            this.downstream.onSubscribe(new Flow.Subscription(){

                @Override
                public void request(long n) {
                    if (!cancelled) {
                        upstream.request(n);
                    }
                }

                @Override
                public void cancel() {
                    cancelled = true;
                    upstream.cancel();
                }
            });
        }

        @Override
        public void onNext(T item) {
            if (this.cancelled) {
                return;
            }
            try {
                R result = this.mapper.apply(item);
                this.downstream.onNext(result);
            }
            catch (Exception e) {
                this.cancelled = true;
                this.upstream.cancel();
                this.downstream.onError(e);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (!this.cancelled) {
                this.downstream.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (!this.cancelled) {
                this.downstream.onComplete();
            }
        }
    }

    private static class AsyncMappingSubscriber<T, R>
    implements Flow.Subscriber<T> {
        private final Flow.Subscriber<? super R> downstream;
        private final Function<T, CompletableFuture<R>> mapper;
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private final AtomicLong pendingDemand = new AtomicLong(0L);
        private final AtomicLong pendingCompletes = new AtomicLong(0L);
        private Flow.Subscription upstream;
        private volatile boolean upstreamCompleted = false;

        public AsyncMappingSubscriber(Flow.Subscriber<? super R> downstream, Function<T, CompletableFuture<R>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.upstream = subscription;
            this.downstream.onSubscribe(new Flow.Subscription(){

                @Override
                public void request(long n) {
                    if (n <= 0L) {
                        downstream.onError(new IllegalArgumentException("Request count must be positive"));
                        return;
                    }
                    long currentDemand = pendingDemand.addAndGet(n);
                    if (currentDemand < 0L) {
                        pendingDemand.set(Long.MAX_VALUE);
                    }
                    upstream.request(n);
                }

                @Override
                public void cancel() {
                    cancelled.set(true);
                    upstream.cancel();
                }
            });
        }

        @Override
        public void onNext(T item) {
            block3: {
                if (this.cancelled.get()) {
                    return;
                }
                try {
                    this.pendingCompletes.incrementAndGet();
                    CompletableFuture<R> future = this.mapper.apply(item);
                    future.whenComplete((result, error) -> {
                        if (this.cancelled.get()) {
                            return;
                        }
                        if (error != null) {
                            this.cancelled.set(true);
                            this.downstream.onError((Throwable)error);
                        } else if (this.pendingDemand.get() > 0L) {
                            this.pendingDemand.decrementAndGet();
                            this.downstream.onNext(result);
                        }
                        if (this.pendingCompletes.decrementAndGet() == 0L && this.upstreamCompleted) {
                            this.downstream.onComplete();
                        }
                    });
                }
                catch (Exception e) {
                    if (this.cancelled.get()) break block3;
                    this.cancelled.set(true);
                    this.downstream.onError(e);
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (!this.cancelled.get()) {
                this.downstream.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            this.upstreamCompleted = true;
            if (!this.cancelled.get() && this.pendingCompletes.get() == 0L) {
                this.downstream.onComplete();
            }
        }
    }

    private static final class ConcatPublisher<T>
    implements Flow.Publisher<T> {
        private final List<Flow.Publisher<T>> pubs;

        ConcatPublisher(List<Flow.Publisher<T>> pubs) {
            this.pubs = List.copyOf(pubs);
        }

        @Override
        public void subscribe(Flow.Subscriber<? super T> downstream) {
            downstream.onSubscribe(new ConcatSubscription<T>(downstream, this.pubs.iterator()));
        }
    }

    private static class FlatteningPublisher<T, R>
    implements Flow.Publisher<R> {
        private final Flow.Publisher<T> source;
        private final Function<T, Iterable<R>> flattener;

        public FlatteningPublisher(Flow.Publisher<T> source, Function<T, Iterable<R>> flattener) {
            this.source = source;
            this.flattener = flattener;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super R> subscriber) {
            this.source.subscribe(new FlatteningSubscriber<T, R>(subscriber, this.flattener));
        }
    }

    private static class SyncMappingPublisher<T, R>
    implements Flow.Publisher<R> {
        private final Flow.Publisher<T> source;
        private final Function<T, R> mapper;

        public SyncMappingPublisher(Flow.Publisher<T> source, Function<T, R> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super R> subscriber) {
            this.source.subscribe(new SyncMappingSubscriber<T, R>(subscriber, this.mapper));
        }
    }

    private static class AsyncMappingPublisher<T, R>
    implements Flow.Publisher<R> {
        private final Flow.Publisher<T> source;
        private final Function<T, CompletableFuture<R>> mapper;

        public AsyncMappingPublisher(Flow.Publisher<T> source, Function<T, CompletableFuture<R>> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super R> subscriber) {
            this.source.subscribe(new AsyncMappingSubscriber<T, R>(subscriber, this.mapper));
        }
    }
}

