/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;


/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * UpdateEmployeeApiModelEmploymentValue - The pay period of the job postings.
 */
@JsonDeserialize(using = UpdateEmployeeApiModelEmploymentValue._Deserializer.class)
@JsonSerialize(using = UpdateEmployeeApiModelEmploymentValue._Serializer.class)
public class UpdateEmployeeApiModelEmploymentValue {

    public static final UpdateEmployeeApiModelEmploymentValue HOUR = new UpdateEmployeeApiModelEmploymentValue("hour");
    public static final UpdateEmployeeApiModelEmploymentValue DAY = new UpdateEmployeeApiModelEmploymentValue("day");
    public static final UpdateEmployeeApiModelEmploymentValue WEEK = new UpdateEmployeeApiModelEmploymentValue("week");
    public static final UpdateEmployeeApiModelEmploymentValue EVERY_TWO_WEEKS = new UpdateEmployeeApiModelEmploymentValue("every_two_weeks");
    public static final UpdateEmployeeApiModelEmploymentValue MONTH = new UpdateEmployeeApiModelEmploymentValue("month");
    public static final UpdateEmployeeApiModelEmploymentValue TWICE_A_MONTH = new UpdateEmployeeApiModelEmploymentValue("twice_a_month");
    public static final UpdateEmployeeApiModelEmploymentValue EVERY_TWO_MONTHS = new UpdateEmployeeApiModelEmploymentValue("every_two_months");
    public static final UpdateEmployeeApiModelEmploymentValue QUARTER = new UpdateEmployeeApiModelEmploymentValue("quarter");
    public static final UpdateEmployeeApiModelEmploymentValue EVERY_SIX_MONTHS = new UpdateEmployeeApiModelEmploymentValue("every_six_months");
    public static final UpdateEmployeeApiModelEmploymentValue YEAR = new UpdateEmployeeApiModelEmploymentValue("year");
    public static final UpdateEmployeeApiModelEmploymentValue ONE_OFF = new UpdateEmployeeApiModelEmploymentValue("one_off");
    public static final UpdateEmployeeApiModelEmploymentValue NONE = new UpdateEmployeeApiModelEmploymentValue("none");
    public static final UpdateEmployeeApiModelEmploymentValue UNMAPPED_VALUE = new UpdateEmployeeApiModelEmploymentValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, UpdateEmployeeApiModelEmploymentValue> values = createValuesMap();
    private static final Map<String, UpdateEmployeeApiModelEmploymentValueEnum> enums = createEnumsMap();

    private final String value;

    private UpdateEmployeeApiModelEmploymentValue(String value) {
        this.value = value;
    }

    /**
     * Returns a UpdateEmployeeApiModelEmploymentValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as UpdateEmployeeApiModelEmploymentValue
     */ 
    public static UpdateEmployeeApiModelEmploymentValue of(String value) {
        synchronized (UpdateEmployeeApiModelEmploymentValue.class) {
            return values.computeIfAbsent(value, v -> new UpdateEmployeeApiModelEmploymentValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<UpdateEmployeeApiModelEmploymentValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        UpdateEmployeeApiModelEmploymentValue other = (UpdateEmployeeApiModelEmploymentValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "UpdateEmployeeApiModelEmploymentValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static UpdateEmployeeApiModelEmploymentValue[] values() {
        synchronized (UpdateEmployeeApiModelEmploymentValue.class) {
            return values.values().toArray(new UpdateEmployeeApiModelEmploymentValue[] {});
        }
    }

    private static final Map<String, UpdateEmployeeApiModelEmploymentValue> createValuesMap() {
        Map<String, UpdateEmployeeApiModelEmploymentValue> map = new LinkedHashMap<>();
        map.put("hour", HOUR);
        map.put("day", DAY);
        map.put("week", WEEK);
        map.put("every_two_weeks", EVERY_TWO_WEEKS);
        map.put("month", MONTH);
        map.put("twice_a_month", TWICE_A_MONTH);
        map.put("every_two_months", EVERY_TWO_MONTHS);
        map.put("quarter", QUARTER);
        map.put("every_six_months", EVERY_SIX_MONTHS);
        map.put("year", YEAR);
        map.put("one_off", ONE_OFF);
        map.put("none", NONE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, UpdateEmployeeApiModelEmploymentValueEnum> createEnumsMap() {
        Map<String, UpdateEmployeeApiModelEmploymentValueEnum> map = new HashMap<>();
        map.put("hour", UpdateEmployeeApiModelEmploymentValueEnum.HOUR);
        map.put("day", UpdateEmployeeApiModelEmploymentValueEnum.DAY);
        map.put("week", UpdateEmployeeApiModelEmploymentValueEnum.WEEK);
        map.put("every_two_weeks", UpdateEmployeeApiModelEmploymentValueEnum.EVERY_TWO_WEEKS);
        map.put("month", UpdateEmployeeApiModelEmploymentValueEnum.MONTH);
        map.put("twice_a_month", UpdateEmployeeApiModelEmploymentValueEnum.TWICE_A_MONTH);
        map.put("every_two_months", UpdateEmployeeApiModelEmploymentValueEnum.EVERY_TWO_MONTHS);
        map.put("quarter", UpdateEmployeeApiModelEmploymentValueEnum.QUARTER);
        map.put("every_six_months", UpdateEmployeeApiModelEmploymentValueEnum.EVERY_SIX_MONTHS);
        map.put("year", UpdateEmployeeApiModelEmploymentValueEnum.YEAR);
        map.put("one_off", UpdateEmployeeApiModelEmploymentValueEnum.ONE_OFF);
        map.put("none", UpdateEmployeeApiModelEmploymentValueEnum.NONE);
        map.put("unmapped_value", UpdateEmployeeApiModelEmploymentValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<UpdateEmployeeApiModelEmploymentValue> {

        protected _Serializer() {
            super(UpdateEmployeeApiModelEmploymentValue.class);
        }

        @Override
        public void serialize(UpdateEmployeeApiModelEmploymentValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<UpdateEmployeeApiModelEmploymentValue> {

        protected _Deserializer() {
            super(UpdateEmployeeApiModelEmploymentValue.class);
        }

        @Override
        public UpdateEmployeeApiModelEmploymentValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return UpdateEmployeeApiModelEmploymentValue.of(v);
        }
    }
    
    public enum UpdateEmployeeApiModelEmploymentValueEnum {

        HOUR("hour"),
        DAY("day"),
        WEEK("week"),
        EVERY_TWO_WEEKS("every_two_weeks"),
        MONTH("month"),
        TWICE_A_MONTH("twice_a_month"),
        EVERY_TWO_MONTHS("every_two_months"),
        QUARTER("quarter"),
        EVERY_SIX_MONTHS("every_six_months"),
        YEAR("year"),
        ONE_OFF("one_off"),
        NONE("none"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private UpdateEmployeeApiModelEmploymentValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}
