/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class BackgroundCheckOrderApplication {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("application_status")
    private JsonNullable<? extends BackgroundCheckOrderApplicationStatus> applicationStatus;

    /**
     * Value to pass through to the provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("passthrough")
    private JsonNullable<? extends Map<String, Object>> passthrough;

    @JsonCreator
    public BackgroundCheckOrderApplication(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("application_status") JsonNullable<? extends BackgroundCheckOrderApplicationStatus> applicationStatus,
            @JsonProperty("passthrough") JsonNullable<? extends Map<String, Object>> passthrough) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(applicationStatus, "applicationStatus");
        Utils.checkNotNull(passthrough, "passthrough");
        this.id = id;
        this.remoteId = remoteId;
        this.applicationStatus = applicationStatus;
        this.passthrough = passthrough;
    }
    
    public BackgroundCheckOrderApplication() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<BackgroundCheckOrderApplicationStatus> applicationStatus() {
        return (JsonNullable<BackgroundCheckOrderApplicationStatus>) applicationStatus;
    }

    /**
     * Value to pass through to the provider
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> passthrough() {
        return (JsonNullable<Map<String, Object>>) passthrough;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Unique identifier
     */
    public BackgroundCheckOrderApplication withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public BackgroundCheckOrderApplication withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public BackgroundCheckOrderApplication withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public BackgroundCheckOrderApplication withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    public BackgroundCheckOrderApplication withApplicationStatus(BackgroundCheckOrderApplicationStatus applicationStatus) {
        Utils.checkNotNull(applicationStatus, "applicationStatus");
        this.applicationStatus = JsonNullable.of(applicationStatus);
        return this;
    }

    public BackgroundCheckOrderApplication withApplicationStatus(JsonNullable<? extends BackgroundCheckOrderApplicationStatus> applicationStatus) {
        Utils.checkNotNull(applicationStatus, "applicationStatus");
        this.applicationStatus = applicationStatus;
        return this;
    }

    /**
     * Value to pass through to the provider
     */
    public BackgroundCheckOrderApplication withPassthrough(Map<String, Object> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = JsonNullable.of(passthrough);
        return this;
    }

    /**
     * Value to pass through to the provider
     */
    public BackgroundCheckOrderApplication withPassthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = passthrough;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BackgroundCheckOrderApplication other = (BackgroundCheckOrderApplication) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.remoteId, other.remoteId) &&
            Objects.deepEquals(this.applicationStatus, other.applicationStatus) &&
            Objects.deepEquals(this.passthrough, other.passthrough);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            remoteId,
            applicationStatus,
            passthrough);
    }
    
    @Override
    public String toString() {
        return Utils.toString(BackgroundCheckOrderApplication.class,
                "id", id,
                "remoteId", remoteId,
                "applicationStatus", applicationStatus,
                "passthrough", passthrough);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<? extends BackgroundCheckOrderApplicationStatus> applicationStatus = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> passthrough = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        public Builder applicationStatus(BackgroundCheckOrderApplicationStatus applicationStatus) {
            Utils.checkNotNull(applicationStatus, "applicationStatus");
            this.applicationStatus = JsonNullable.of(applicationStatus);
            return this;
        }

        public Builder applicationStatus(JsonNullable<? extends BackgroundCheckOrderApplicationStatus> applicationStatus) {
            Utils.checkNotNull(applicationStatus, "applicationStatus");
            this.applicationStatus = applicationStatus;
            return this;
        }

        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(Map<String, Object> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = JsonNullable.of(passthrough);
            return this;
        }

        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = passthrough;
            return this;
        }
        
        public BackgroundCheckOrderApplication build() {
            return new BackgroundCheckOrderApplication(
                id,
                remoteId,
                applicationStatus,
                passthrough);
        }
    }
}
