/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.CustomFieldDefinitionSourceValue;
import com.stackone.stackone_client_java.models.components.CustomFieldDefinitionValue;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class Type {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends CustomFieldDefinitionValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends CustomFieldDefinitionSourceValue> sourceValue;

    @JsonCreator
    public Type(@JsonProperty(value="value") JsonNullable<? extends CustomFieldDefinitionValue> value, @JsonProperty(value="source_value") JsonNullable<? extends CustomFieldDefinitionSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public Type() {
        this((JsonNullable<? extends CustomFieldDefinitionValue>)JsonNullable.undefined(), (JsonNullable<? extends CustomFieldDefinitionSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<CustomFieldDefinitionValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<CustomFieldDefinitionSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public Type withValue(CustomFieldDefinitionValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public Type withValue(JsonNullable<? extends CustomFieldDefinitionValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public Type withSourceValue(CustomFieldDefinitionSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public Type withSourceValue(JsonNullable<? extends CustomFieldDefinitionSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Type other = (Type)o;
        return Objects.deepEquals(this.value, other.value) && Objects.deepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(Type.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends CustomFieldDefinitionValue> value = JsonNullable.undefined();
        private JsonNullable<? extends CustomFieldDefinitionSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(CustomFieldDefinitionValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends CustomFieldDefinitionValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(CustomFieldDefinitionSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends CustomFieldDefinitionSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public Type build() {
            return new Type(this.value, this.sourceValue);
        }
    }
}

