/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.utils.LazySingletonValue;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class ProxyRequestBody {

    /**
     * The base url of the request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("url")
    private JsonNullable<String> url;

    /**
     * The method of the request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("method")
    private JsonNullable<? extends Method> method;

    /**
     * The path of the request including any query paramters
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("path")
    private JsonNullable<String> path;

    /**
     * The headers to send in the request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("headers")
    private JsonNullable<? extends Map<String, Object>> headers;

    /**
     * The body of the request
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("body")
    private JsonNullable<? extends Map<String, Object>> body;

    @JsonCreator
    public ProxyRequestBody(
            @JsonProperty("url") JsonNullable<String> url,
            @JsonProperty("method") JsonNullable<? extends Method> method,
            @JsonProperty("path") JsonNullable<String> path,
            @JsonProperty("headers") JsonNullable<? extends Map<String, Object>> headers,
            @JsonProperty("body") JsonNullable<? extends Map<String, Object>> body) {
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(method, "method");
        Utils.checkNotNull(path, "path");
        Utils.checkNotNull(headers, "headers");
        Utils.checkNotNull(body, "body");
        this.url = url;
        this.method = method;
        this.path = path;
        this.headers = headers;
        this.body = body;
    }
    
    public ProxyRequestBody() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The base url of the request
     */
    @JsonIgnore
    public JsonNullable<String> url() {
        return url;
    }

    /**
     * The method of the request
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Method> method() {
        return (JsonNullable<Method>) method;
    }

    /**
     * The path of the request including any query paramters
     */
    @JsonIgnore
    public JsonNullable<String> path() {
        return path;
    }

    /**
     * The headers to send in the request
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> headers() {
        return (JsonNullable<Map<String, Object>>) headers;
    }

    /**
     * The body of the request
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> body() {
        return (JsonNullable<Map<String, Object>>) body;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The base url of the request
     */
    public ProxyRequestBody withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = JsonNullable.of(url);
        return this;
    }

    /**
     * The base url of the request
     */
    public ProxyRequestBody withUrl(JsonNullable<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    /**
     * The method of the request
     */
    public ProxyRequestBody withMethod(Method method) {
        Utils.checkNotNull(method, "method");
        this.method = JsonNullable.of(method);
        return this;
    }

    /**
     * The method of the request
     */
    public ProxyRequestBody withMethod(JsonNullable<? extends Method> method) {
        Utils.checkNotNull(method, "method");
        this.method = method;
        return this;
    }

    /**
     * The path of the request including any query paramters
     */
    public ProxyRequestBody withPath(String path) {
        Utils.checkNotNull(path, "path");
        this.path = JsonNullable.of(path);
        return this;
    }

    /**
     * The path of the request including any query paramters
     */
    public ProxyRequestBody withPath(JsonNullable<String> path) {
        Utils.checkNotNull(path, "path");
        this.path = path;
        return this;
    }

    /**
     * The headers to send in the request
     */
    public ProxyRequestBody withHeaders(Map<String, Object> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = JsonNullable.of(headers);
        return this;
    }

    /**
     * The headers to send in the request
     */
    public ProxyRequestBody withHeaders(JsonNullable<? extends Map<String, Object>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    /**
     * The body of the request
     */
    public ProxyRequestBody withBody(Map<String, Object> body) {
        Utils.checkNotNull(body, "body");
        this.body = JsonNullable.of(body);
        return this;
    }

    /**
     * The body of the request
     */
    public ProxyRequestBody withBody(JsonNullable<? extends Map<String, Object>> body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProxyRequestBody other = (ProxyRequestBody) o;
        return 
            Objects.deepEquals(this.url, other.url) &&
            Objects.deepEquals(this.method, other.method) &&
            Objects.deepEquals(this.path, other.path) &&
            Objects.deepEquals(this.headers, other.headers) &&
            Objects.deepEquals(this.body, other.body);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            url,
            method,
            path,
            headers,
            body);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ProxyRequestBody.class,
                "url", url,
                "method", method,
                "path", path,
                "headers", headers,
                "body", body);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> url = JsonNullable.undefined();
 
        private JsonNullable<? extends Method> method;
 
        private JsonNullable<String> path = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> headers = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> body = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The base url of the request
         */
        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = JsonNullable.of(url);
            return this;
        }

        /**
         * The base url of the request
         */
        public Builder url(JsonNullable<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }

        /**
         * The method of the request
         */
        public Builder method(Method method) {
            Utils.checkNotNull(method, "method");
            this.method = JsonNullable.of(method);
            return this;
        }

        /**
         * The method of the request
         */
        public Builder method(JsonNullable<? extends Method> method) {
            Utils.checkNotNull(method, "method");
            this.method = method;
            return this;
        }

        /**
         * The path of the request including any query paramters
         */
        public Builder path(String path) {
            Utils.checkNotNull(path, "path");
            this.path = JsonNullable.of(path);
            return this;
        }

        /**
         * The path of the request including any query paramters
         */
        public Builder path(JsonNullable<String> path) {
            Utils.checkNotNull(path, "path");
            this.path = path;
            return this;
        }

        /**
         * The headers to send in the request
         */
        public Builder headers(Map<String, Object> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = JsonNullable.of(headers);
            return this;
        }

        /**
         * The headers to send in the request
         */
        public Builder headers(JsonNullable<? extends Map<String, Object>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        /**
         * The body of the request
         */
        public Builder body(Map<String, Object> body) {
            Utils.checkNotNull(body, "body");
            this.body = JsonNullable.of(body);
            return this;
        }

        /**
         * The body of the request
         */
        public Builder body(JsonNullable<? extends Map<String, Object>> body) {
            Utils.checkNotNull(body, "body");
            this.body = body;
            return this;
        }
        
        public ProxyRequestBody build() {
            if (method == null) {
                method = _SINGLETON_VALUE_Method.value();
            }
            return new ProxyRequestBody(
                url,
                method,
                path,
                headers,
                body);
        }

        private static final LazySingletonValue<JsonNullable<? extends Method>> _SINGLETON_VALUE_Method =
                new LazySingletonValue<>(
                        "method",
                        "\"get\"",
                        new TypeReference<JsonNullable<? extends Method>>() {});
    }
}
