/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * StepLogUrl
 * 
 * <p>The request URL data
 */
public class StepLogUrl {

    /**
     * The request URL
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("url")
    private JsonNullable<String> url;

    /**
     * The request URL hostname
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("hostname")
    private JsonNullable<String> hostname;

    /**
     * The request path
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("path")
    private JsonNullable<String> path;

    /**
     * The request query parameters
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("query_params")
    private JsonNullable<? extends Map<String, Object>> queryParams;

    @JsonCreator
    public StepLogUrl(
            @JsonProperty("url") JsonNullable<String> url,
            @JsonProperty("hostname") JsonNullable<String> hostname,
            @JsonProperty("path") JsonNullable<String> path,
            @JsonProperty("query_params") JsonNullable<? extends Map<String, Object>> queryParams) {
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(hostname, "hostname");
        Utils.checkNotNull(path, "path");
        Utils.checkNotNull(queryParams, "queryParams");
        this.url = url;
        this.hostname = hostname;
        this.path = path;
        this.queryParams = queryParams;
    }
    
    public StepLogUrl() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The request URL
     */
    @JsonIgnore
    public JsonNullable<String> url() {
        return url;
    }

    /**
     * The request URL hostname
     */
    @JsonIgnore
    public JsonNullable<String> hostname() {
        return hostname;
    }

    /**
     * The request path
     */
    @JsonIgnore
    public JsonNullable<String> path() {
        return path;
    }

    /**
     * The request query parameters
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> queryParams() {
        return (JsonNullable<Map<String, Object>>) queryParams;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The request URL
     */
    public StepLogUrl withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = JsonNullable.of(url);
        return this;
    }

    /**
     * The request URL
     */
    public StepLogUrl withUrl(JsonNullable<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    /**
     * The request URL hostname
     */
    public StepLogUrl withHostname(String hostname) {
        Utils.checkNotNull(hostname, "hostname");
        this.hostname = JsonNullable.of(hostname);
        return this;
    }

    /**
     * The request URL hostname
     */
    public StepLogUrl withHostname(JsonNullable<String> hostname) {
        Utils.checkNotNull(hostname, "hostname");
        this.hostname = hostname;
        return this;
    }

    /**
     * The request path
     */
    public StepLogUrl withPath(String path) {
        Utils.checkNotNull(path, "path");
        this.path = JsonNullable.of(path);
        return this;
    }

    /**
     * The request path
     */
    public StepLogUrl withPath(JsonNullable<String> path) {
        Utils.checkNotNull(path, "path");
        this.path = path;
        return this;
    }

    /**
     * The request query parameters
     */
    public StepLogUrl withQueryParams(Map<String, Object> queryParams) {
        Utils.checkNotNull(queryParams, "queryParams");
        this.queryParams = JsonNullable.of(queryParams);
        return this;
    }

    /**
     * The request query parameters
     */
    public StepLogUrl withQueryParams(JsonNullable<? extends Map<String, Object>> queryParams) {
        Utils.checkNotNull(queryParams, "queryParams");
        this.queryParams = queryParams;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StepLogUrl other = (StepLogUrl) o;
        return 
            Objects.deepEquals(this.url, other.url) &&
            Objects.deepEquals(this.hostname, other.hostname) &&
            Objects.deepEquals(this.path, other.path) &&
            Objects.deepEquals(this.queryParams, other.queryParams);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            url,
            hostname,
            path,
            queryParams);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StepLogUrl.class,
                "url", url,
                "hostname", hostname,
                "path", path,
                "queryParams", queryParams);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> url = JsonNullable.undefined();
 
        private JsonNullable<String> hostname = JsonNullable.undefined();
 
        private JsonNullable<String> path = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> queryParams = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The request URL
         */
        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = JsonNullable.of(url);
            return this;
        }

        /**
         * The request URL
         */
        public Builder url(JsonNullable<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }

        /**
         * The request URL hostname
         */
        public Builder hostname(String hostname) {
            Utils.checkNotNull(hostname, "hostname");
            this.hostname = JsonNullable.of(hostname);
            return this;
        }

        /**
         * The request URL hostname
         */
        public Builder hostname(JsonNullable<String> hostname) {
            Utils.checkNotNull(hostname, "hostname");
            this.hostname = hostname;
            return this;
        }

        /**
         * The request path
         */
        public Builder path(String path) {
            Utils.checkNotNull(path, "path");
            this.path = JsonNullable.of(path);
            return this;
        }

        /**
         * The request path
         */
        public Builder path(JsonNullable<String> path) {
            Utils.checkNotNull(path, "path");
            this.path = path;
            return this;
        }

        /**
         * The request query parameters
         */
        public Builder queryParams(Map<String, Object> queryParams) {
            Utils.checkNotNull(queryParams, "queryParams");
            this.queryParams = JsonNullable.of(queryParams);
            return this;
        }

        /**
         * The request query parameters
         */
        public Builder queryParams(JsonNullable<? extends Map<String, Object>> queryParams) {
            Utils.checkNotNull(queryParams, "queryParams");
            this.queryParams = queryParams;
            return this;
        }
        
        public StepLogUrl build() {
            return new StepLogUrl(
                url,
                hostname,
                path,
                queryParams);
        }
    }
}
