/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class Campaign {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * The created_at date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The updated_at date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;

    /**
     * The schedule type
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("schedule_type")
    private JsonNullable<? extends ScheduleType> scheduleType;

    /**
     * Status of the Campaign
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private JsonNullable<? extends CampaignStatus> status;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("archived")
    private JsonNullable<? extends Archived> archived;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("draft")
    private JsonNullable<? extends Draft> draft;

    /**
     * channels of the Campaign
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("channels")
    private JsonNullable<? extends List<ChannelsEnum>> channels;

    /**
     * The first_sent_at date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("first_sent_at")
    private JsonNullable<OffsetDateTime> firstSentAt;

    /**
     * The last_sent_at date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("last_sent_at")
    private JsonNullable<OffsetDateTime> lastSentAt;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("tags")
    private JsonNullable<? extends List<String>> tags;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("messages")
    private JsonNullable<? extends List<Message>> messages;

    @JsonCreator
    public Campaign(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt,
            @JsonProperty("description") JsonNullable<String> description,
            @JsonProperty("schedule_type") JsonNullable<? extends ScheduleType> scheduleType,
            @JsonProperty("status") JsonNullable<? extends CampaignStatus> status,
            @JsonProperty("archived") JsonNullable<? extends Archived> archived,
            @JsonProperty("draft") JsonNullable<? extends Draft> draft,
            @JsonProperty("channels") JsonNullable<? extends List<ChannelsEnum>> channels,
            @JsonProperty("first_sent_at") JsonNullable<OffsetDateTime> firstSentAt,
            @JsonProperty("last_sent_at") JsonNullable<OffsetDateTime> lastSentAt,
            @JsonProperty("tags") JsonNullable<? extends List<String>> tags,
            @JsonProperty("messages") JsonNullable<? extends List<Message>> messages) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(scheduleType, "scheduleType");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(archived, "archived");
        Utils.checkNotNull(draft, "draft");
        Utils.checkNotNull(channels, "channels");
        Utils.checkNotNull(firstSentAt, "firstSentAt");
        Utils.checkNotNull(lastSentAt, "lastSentAt");
        Utils.checkNotNull(tags, "tags");
        Utils.checkNotNull(messages, "messages");
        this.id = id;
        this.remoteId = remoteId;
        this.name = name;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.description = description;
        this.scheduleType = scheduleType;
        this.status = status;
        this.archived = archived;
        this.draft = draft;
        this.channels = channels;
        this.firstSentAt = firstSentAt;
        this.lastSentAt = lastSentAt;
        this.tags = tags;
        this.messages = messages;
    }
    
    public Campaign() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * The created_at date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The updated_at date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    /**
     * The schedule type
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ScheduleType> scheduleType() {
        return (JsonNullable<ScheduleType>) scheduleType;
    }

    /**
     * Status of the Campaign
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CampaignStatus> status() {
        return (JsonNullable<CampaignStatus>) status;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Archived> archived() {
        return (JsonNullable<Archived>) archived;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Draft> draft() {
        return (JsonNullable<Draft>) draft;
    }

    /**
     * channels of the Campaign
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<ChannelsEnum>> channels() {
        return (JsonNullable<List<ChannelsEnum>>) channels;
    }

    /**
     * The first_sent_at date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> firstSentAt() {
        return firstSentAt;
    }

    /**
     * The last_sent_at date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> lastSentAt() {
        return lastSentAt;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> tags() {
        return (JsonNullable<List<String>>) tags;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<Message>> messages() {
        return (JsonNullable<List<Message>>) messages;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Unique identifier
     */
    public Campaign withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Campaign withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Campaign withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Campaign withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    public Campaign withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    public Campaign withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * The created_at date
     */
    public Campaign withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The created_at date
     */
    public Campaign withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The updated_at date
     */
    public Campaign withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The updated_at date
     */
    public Campaign withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public Campaign withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    public Campaign withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * The schedule type
     */
    public Campaign withScheduleType(ScheduleType scheduleType) {
        Utils.checkNotNull(scheduleType, "scheduleType");
        this.scheduleType = JsonNullable.of(scheduleType);
        return this;
    }

    /**
     * The schedule type
     */
    public Campaign withScheduleType(JsonNullable<? extends ScheduleType> scheduleType) {
        Utils.checkNotNull(scheduleType, "scheduleType");
        this.scheduleType = scheduleType;
        return this;
    }

    /**
     * Status of the Campaign
     */
    public Campaign withStatus(CampaignStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * Status of the Campaign
     */
    public Campaign withStatus(JsonNullable<? extends CampaignStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public Campaign withArchived(Archived archived) {
        Utils.checkNotNull(archived, "archived");
        this.archived = JsonNullable.of(archived);
        return this;
    }

    public Campaign withArchived(JsonNullable<? extends Archived> archived) {
        Utils.checkNotNull(archived, "archived");
        this.archived = archived;
        return this;
    }

    public Campaign withDraft(Draft draft) {
        Utils.checkNotNull(draft, "draft");
        this.draft = JsonNullable.of(draft);
        return this;
    }

    public Campaign withDraft(JsonNullable<? extends Draft> draft) {
        Utils.checkNotNull(draft, "draft");
        this.draft = draft;
        return this;
    }

    /**
     * channels of the Campaign
     */
    public Campaign withChannels(List<ChannelsEnum> channels) {
        Utils.checkNotNull(channels, "channels");
        this.channels = JsonNullable.of(channels);
        return this;
    }

    /**
     * channels of the Campaign
     */
    public Campaign withChannels(JsonNullable<? extends List<ChannelsEnum>> channels) {
        Utils.checkNotNull(channels, "channels");
        this.channels = channels;
        return this;
    }

    /**
     * The first_sent_at date
     */
    public Campaign withFirstSentAt(OffsetDateTime firstSentAt) {
        Utils.checkNotNull(firstSentAt, "firstSentAt");
        this.firstSentAt = JsonNullable.of(firstSentAt);
        return this;
    }

    /**
     * The first_sent_at date
     */
    public Campaign withFirstSentAt(JsonNullable<OffsetDateTime> firstSentAt) {
        Utils.checkNotNull(firstSentAt, "firstSentAt");
        this.firstSentAt = firstSentAt;
        return this;
    }

    /**
     * The last_sent_at date
     */
    public Campaign withLastSentAt(OffsetDateTime lastSentAt) {
        Utils.checkNotNull(lastSentAt, "lastSentAt");
        this.lastSentAt = JsonNullable.of(lastSentAt);
        return this;
    }

    /**
     * The last_sent_at date
     */
    public Campaign withLastSentAt(JsonNullable<OffsetDateTime> lastSentAt) {
        Utils.checkNotNull(lastSentAt, "lastSentAt");
        this.lastSentAt = lastSentAt;
        return this;
    }

    public Campaign withTags(List<String> tags) {
        Utils.checkNotNull(tags, "tags");
        this.tags = JsonNullable.of(tags);
        return this;
    }

    public Campaign withTags(JsonNullable<? extends List<String>> tags) {
        Utils.checkNotNull(tags, "tags");
        this.tags = tags;
        return this;
    }

    public Campaign withMessages(List<Message> messages) {
        Utils.checkNotNull(messages, "messages");
        this.messages = JsonNullable.of(messages);
        return this;
    }

    public Campaign withMessages(JsonNullable<? extends List<Message>> messages) {
        Utils.checkNotNull(messages, "messages");
        this.messages = messages;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Campaign other = (Campaign) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt) &&
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.scheduleType, other.scheduleType) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.archived, other.archived) &&
            Utils.enhancedDeepEquals(this.draft, other.draft) &&
            Utils.enhancedDeepEquals(this.channels, other.channels) &&
            Utils.enhancedDeepEquals(this.firstSentAt, other.firstSentAt) &&
            Utils.enhancedDeepEquals(this.lastSentAt, other.lastSentAt) &&
            Utils.enhancedDeepEquals(this.tags, other.tags) &&
            Utils.enhancedDeepEquals(this.messages, other.messages);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id,
            remoteId,
            name,
            createdAt,
            updatedAt,
            description,
            scheduleType,
            status,
            archived,
            draft,
            channels,
            firstSentAt,
            lastSentAt,
            tags,
            messages);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Campaign.class,
                "id", id,
                "remoteId", remoteId,
                "name", name,
                "createdAt", createdAt,
                "updatedAt", updatedAt,
                "description", description,
                "scheduleType", scheduleType,
                "status", status,
                "archived", archived,
                "draft", draft,
                "channels", channels,
                "firstSentAt", firstSentAt,
                "lastSentAt", lastSentAt,
                "tags", tags,
                "messages", messages);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<String> name = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();
 
        private JsonNullable<String> description = JsonNullable.undefined();
 
        private JsonNullable<? extends ScheduleType> scheduleType = JsonNullable.undefined();
 
        private JsonNullable<? extends CampaignStatus> status = JsonNullable.undefined();
 
        private JsonNullable<? extends Archived> archived = JsonNullable.undefined();
 
        private JsonNullable<? extends Draft> draft = JsonNullable.undefined();
 
        private JsonNullable<? extends List<ChannelsEnum>> channels = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> firstSentAt = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> lastSentAt = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> tags = JsonNullable.undefined();
 
        private JsonNullable<? extends List<Message>> messages = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        /**
         * The created_at date
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The created_at date
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        /**
         * The updated_at date
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The updated_at date
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }

        /**
         * The schedule type
         */
        public Builder scheduleType(ScheduleType scheduleType) {
            Utils.checkNotNull(scheduleType, "scheduleType");
            this.scheduleType = JsonNullable.of(scheduleType);
            return this;
        }

        /**
         * The schedule type
         */
        public Builder scheduleType(JsonNullable<? extends ScheduleType> scheduleType) {
            Utils.checkNotNull(scheduleType, "scheduleType");
            this.scheduleType = scheduleType;
            return this;
        }

        /**
         * Status of the Campaign
         */
        public Builder status(CampaignStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * Status of the Campaign
         */
        public Builder status(JsonNullable<? extends CampaignStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder archived(Archived archived) {
            Utils.checkNotNull(archived, "archived");
            this.archived = JsonNullable.of(archived);
            return this;
        }

        public Builder archived(JsonNullable<? extends Archived> archived) {
            Utils.checkNotNull(archived, "archived");
            this.archived = archived;
            return this;
        }

        public Builder draft(Draft draft) {
            Utils.checkNotNull(draft, "draft");
            this.draft = JsonNullable.of(draft);
            return this;
        }

        public Builder draft(JsonNullable<? extends Draft> draft) {
            Utils.checkNotNull(draft, "draft");
            this.draft = draft;
            return this;
        }

        /**
         * channels of the Campaign
         */
        public Builder channels(List<ChannelsEnum> channels) {
            Utils.checkNotNull(channels, "channels");
            this.channels = JsonNullable.of(channels);
            return this;
        }

        /**
         * channels of the Campaign
         */
        public Builder channels(JsonNullable<? extends List<ChannelsEnum>> channels) {
            Utils.checkNotNull(channels, "channels");
            this.channels = channels;
            return this;
        }

        /**
         * The first_sent_at date
         */
        public Builder firstSentAt(OffsetDateTime firstSentAt) {
            Utils.checkNotNull(firstSentAt, "firstSentAt");
            this.firstSentAt = JsonNullable.of(firstSentAt);
            return this;
        }

        /**
         * The first_sent_at date
         */
        public Builder firstSentAt(JsonNullable<OffsetDateTime> firstSentAt) {
            Utils.checkNotNull(firstSentAt, "firstSentAt");
            this.firstSentAt = firstSentAt;
            return this;
        }

        /**
         * The last_sent_at date
         */
        public Builder lastSentAt(OffsetDateTime lastSentAt) {
            Utils.checkNotNull(lastSentAt, "lastSentAt");
            this.lastSentAt = JsonNullable.of(lastSentAt);
            return this;
        }

        /**
         * The last_sent_at date
         */
        public Builder lastSentAt(JsonNullable<OffsetDateTime> lastSentAt) {
            Utils.checkNotNull(lastSentAt, "lastSentAt");
            this.lastSentAt = lastSentAt;
            return this;
        }

        public Builder tags(List<String> tags) {
            Utils.checkNotNull(tags, "tags");
            this.tags = JsonNullable.of(tags);
            return this;
        }

        public Builder tags(JsonNullable<? extends List<String>> tags) {
            Utils.checkNotNull(tags, "tags");
            this.tags = tags;
            return this;
        }

        public Builder messages(List<Message> messages) {
            Utils.checkNotNull(messages, "messages");
            this.messages = JsonNullable.of(messages);
            return this;
        }

        public Builder messages(JsonNullable<? extends List<Message>> messages) {
            Utils.checkNotNull(messages, "messages");
            this.messages = messages;
            return this;
        }
        
        public Campaign build() {
            return new Campaign(
                id,
                remoteId,
                name,
                createdAt,
                updatedAt,
                description,
                scheduleType,
                status,
                archived,
                draft,
                channels,
                firstSentAt,
                lastSentAt,
                tags,
                messages);
        }
    }
}
