/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;

public class CustomMappingError {

    /**
     * The custom mapping identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * The error message
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("message")
    private JsonNullable<String> message;

    /**
     * The target field where the error occurred
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("targetField")
    private JsonNullable<String> targetField;

    @JsonCreator
    public CustomMappingError(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("message") JsonNullable<String> message,
            @JsonProperty("targetField") JsonNullable<String> targetField) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(targetField, "targetField");
        this.id = id;
        this.message = message;
        this.targetField = targetField;
    }
    
    public CustomMappingError() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The custom mapping identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * The error message
     */
    @JsonIgnore
    public JsonNullable<String> message() {
        return message;
    }

    /**
     * The target field where the error occurred
     */
    @JsonIgnore
    public JsonNullable<String> targetField() {
        return targetField;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The custom mapping identifier
     */
    public CustomMappingError withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * The custom mapping identifier
     */
    public CustomMappingError withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * The error message
     */
    public CustomMappingError withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = JsonNullable.of(message);
        return this;
    }

    /**
     * The error message
     */
    public CustomMappingError withMessage(JsonNullable<String> message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    /**
     * The target field where the error occurred
     */
    public CustomMappingError withTargetField(String targetField) {
        Utils.checkNotNull(targetField, "targetField");
        this.targetField = JsonNullable.of(targetField);
        return this;
    }

    /**
     * The target field where the error occurred
     */
    public CustomMappingError withTargetField(JsonNullable<String> targetField) {
        Utils.checkNotNull(targetField, "targetField");
        this.targetField = targetField;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CustomMappingError other = (CustomMappingError) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.message, other.message) &&
            Utils.enhancedDeepEquals(this.targetField, other.targetField);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id,
            message,
            targetField);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CustomMappingError.class,
                "id", id,
                "message", message,
                "targetField", targetField);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> message = JsonNullable.undefined();
 
        private JsonNullable<String> targetField = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The custom mapping identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * The custom mapping identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * The error message
         */
        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = JsonNullable.of(message);
            return this;
        }

        /**
         * The error message
         */
        public Builder message(JsonNullable<String> message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        /**
         * The target field where the error occurred
         */
        public Builder targetField(String targetField) {
            Utils.checkNotNull(targetField, "targetField");
            this.targetField = JsonNullable.of(targetField);
            return this;
        }

        /**
         * The target field where the error occurred
         */
        public Builder targetField(JsonNullable<String> targetField) {
            Utils.checkNotNull(targetField, "targetField");
            this.targetField = targetField;
            return this;
        }
        
        public CustomMappingError build() {
            return new CustomMappingError(
                id,
                message,
                targetField);
        }
    }
}
