/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

public class JobPostingCompensationType {

    /**
     * The type of the compensation.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends JobPostingCompensationValue> value;

    /**
     * The source value of the compensation type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends JobPostingCompensationSourceValue> sourceValue;

    @JsonCreator
    public JobPostingCompensationType(
            @JsonProperty("value") JsonNullable<? extends JobPostingCompensationValue> value,
            @JsonProperty("source_value") JsonNullable<? extends JobPostingCompensationSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public JobPostingCompensationType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The type of the compensation.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<JobPostingCompensationValue> value() {
        return (JsonNullable<JobPostingCompensationValue>) value;
    }

    /**
     * The source value of the compensation type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<JobPostingCompensationSourceValue> sourceValue() {
        return (JsonNullable<JobPostingCompensationSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The type of the compensation.
     */
    public JobPostingCompensationType withValue(JobPostingCompensationValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The type of the compensation.
     */
    public JobPostingCompensationType withValue(JsonNullable<? extends JobPostingCompensationValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the compensation type.
     */
    public JobPostingCompensationType withSourceValue(JobPostingCompensationSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the compensation type.
     */
    public JobPostingCompensationType withSourceValue(JsonNullable<? extends JobPostingCompensationSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        JobPostingCompensationType other = (JobPostingCompensationType) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(JobPostingCompensationType.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends JobPostingCompensationValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends JobPostingCompensationSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The type of the compensation.
         */
        public Builder value(JobPostingCompensationValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The type of the compensation.
         */
        public Builder value(JsonNullable<? extends JobPostingCompensationValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The source value of the compensation type.
         */
        public Builder sourceValue(JobPostingCompensationSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the compensation type.
         */
        public Builder sourceValue(JsonNullable<? extends JobPostingCompensationSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public JobPostingCompensationType build() {
            return new JobPostingCompensationType(
                value,
                sourceValue);
        }
    }
}
