/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

public class MessageType {

    /**
     * The unified message type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends EmailMessagesValue> value;

    /**
     * The original value from the provider used to derive the unified message type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends EmailMessagesSourceValue> sourceValue;

    @JsonCreator
    public MessageType(
            @JsonProperty("value") JsonNullable<? extends EmailMessagesValue> value,
            @JsonProperty("source_value") JsonNullable<? extends EmailMessagesSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public MessageType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The unified message type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmailMessagesValue> value() {
        return (JsonNullable<EmailMessagesValue>) value;
    }

    /**
     * The original value from the provider used to derive the unified message type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmailMessagesSourceValue> sourceValue() {
        return (JsonNullable<EmailMessagesSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The unified message type.
     */
    public MessageType withValue(EmailMessagesValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The unified message type.
     */
    public MessageType withValue(JsonNullable<? extends EmailMessagesValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The original value from the provider used to derive the unified message type.
     */
    public MessageType withSourceValue(EmailMessagesSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The original value from the provider used to derive the unified message type.
     */
    public MessageType withSourceValue(JsonNullable<? extends EmailMessagesSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessageType other = (MessageType) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MessageType.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends EmailMessagesValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends EmailMessagesSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The unified message type.
         */
        public Builder value(EmailMessagesValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The unified message type.
         */
        public Builder value(JsonNullable<? extends EmailMessagesValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The original value from the provider used to derive the unified message type.
         */
        public Builder sourceValue(EmailMessagesSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The original value from the provider used to derive the unified message type.
         */
        public Builder sourceValue(JsonNullable<? extends EmailMessagesSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public MessageType build() {
            return new MessageType(
                value,
                sourceValue);
        }
    }
}
