/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * QuestionValue
 * 
 * <p>The type of the questions.
 */
@JsonDeserialize(using = QuestionValue._Deserializer.class)
@JsonSerialize(using = QuestionValue._Serializer.class)
public class QuestionValue {

    public static final QuestionValue SHORT_TEXT = new QuestionValue("short_text");
    public static final QuestionValue LONG_TEXT = new QuestionValue("long_text");
    public static final QuestionValue ATTACHMENT = new QuestionValue("attachment");
    public static final QuestionValue MULTI_SELECT = new QuestionValue("multi_select");
    public static final QuestionValue SINGLE_SELECT = new QuestionValue("single_select");
    public static final QuestionValue BOOLEAN = new QuestionValue("boolean");
    public static final QuestionValue NUMBER = new QuestionValue("number");
    public static final QuestionValue DATE = new QuestionValue("date");
    public static final QuestionValue VIDEO = new QuestionValue("video");
    public static final QuestionValue REFERENCE_CHECK = new QuestionValue("reference_check");
    public static final QuestionValue URL = new QuestionValue("url");
    public static final QuestionValue UNMAPPED_VALUE = new QuestionValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, QuestionValue> values = createValuesMap();
    private static final Map<String, QuestionValueEnum> enums = createEnumsMap();

    private final String value;

    private QuestionValue(String value) {
        this.value = value;
    }

    /**
     * Returns a QuestionValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as QuestionValue
     */ 
    public static QuestionValue of(String value) {
        synchronized (QuestionValue.class) {
            return values.computeIfAbsent(value, v -> new QuestionValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<QuestionValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        QuestionValue other = (QuestionValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "QuestionValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static QuestionValue[] values() {
        synchronized (QuestionValue.class) {
            return values.values().toArray(new QuestionValue[] {});
        }
    }

    private static final Map<String, QuestionValue> createValuesMap() {
        Map<String, QuestionValue> map = new LinkedHashMap<>();
        map.put("short_text", SHORT_TEXT);
        map.put("long_text", LONG_TEXT);
        map.put("attachment", ATTACHMENT);
        map.put("multi_select", MULTI_SELECT);
        map.put("single_select", SINGLE_SELECT);
        map.put("boolean", BOOLEAN);
        map.put("number", NUMBER);
        map.put("date", DATE);
        map.put("video", VIDEO);
        map.put("reference_check", REFERENCE_CHECK);
        map.put("url", URL);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, QuestionValueEnum> createEnumsMap() {
        Map<String, QuestionValueEnum> map = new HashMap<>();
        map.put("short_text", QuestionValueEnum.SHORT_TEXT);
        map.put("long_text", QuestionValueEnum.LONG_TEXT);
        map.put("attachment", QuestionValueEnum.ATTACHMENT);
        map.put("multi_select", QuestionValueEnum.MULTI_SELECT);
        map.put("single_select", QuestionValueEnum.SINGLE_SELECT);
        map.put("boolean", QuestionValueEnum.BOOLEAN);
        map.put("number", QuestionValueEnum.NUMBER);
        map.put("date", QuestionValueEnum.DATE);
        map.put("video", QuestionValueEnum.VIDEO);
        map.put("reference_check", QuestionValueEnum.REFERENCE_CHECK);
        map.put("url", QuestionValueEnum.URL);
        map.put("unmapped_value", QuestionValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<QuestionValue> {

        protected _Serializer() {
            super(QuestionValue.class);
        }

        @Override
        public void serialize(QuestionValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<QuestionValue> {

        protected _Deserializer() {
            super(QuestionValue.class);
        }

        @Override
        public QuestionValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return QuestionValue.of(v);
        }
    }
    
    public enum QuestionValueEnum {

        SHORT_TEXT("short_text"),
        LONG_TEXT("long_text"),
        ATTACHMENT("attachment"),
        MULTI_SELECT("multi_select"),
        SINGLE_SELECT("single_select"),
        BOOLEAN("boolean"),
        NUMBER("number"),
        DATE("date"),
        VIDEO("video"),
        REFERENCE_CHECK("reference_check"),
        URL("url"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private QuestionValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

