/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * TaskStatus
 * 
 * <p>The status of the task
 */
public class TaskStatus {

    /**
     * The unified value for the status of the task. If the provider does not specify this status, the value will be set to UnmappedValue
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends TaskStatusValue> value;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends TaskStatusSourceValue> sourceValue;

    @JsonCreator
    public TaskStatus(
            @JsonProperty("value") JsonNullable<? extends TaskStatusValue> value,
            @JsonProperty("source_value") JsonNullable<? extends TaskStatusSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public TaskStatus() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The unified value for the status of the task. If the provider does not specify this status, the value will be set to UnmappedValue
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TaskStatusValue> value() {
        return (JsonNullable<TaskStatusValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TaskStatusSourceValue> sourceValue() {
        return (JsonNullable<TaskStatusSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The unified value for the status of the task. If the provider does not specify this status, the value will be set to UnmappedValue
     */
    public TaskStatus withValue(TaskStatusValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The unified value for the status of the task. If the provider does not specify this status, the value will be set to UnmappedValue
     */
    public TaskStatus withValue(JsonNullable<? extends TaskStatusValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public TaskStatus withSourceValue(TaskStatusSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public TaskStatus withSourceValue(JsonNullable<? extends TaskStatusSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TaskStatus other = (TaskStatus) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TaskStatus.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends TaskStatusValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends TaskStatusSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The unified value for the status of the task. If the provider does not specify this status, the value will be set to UnmappedValue
         */
        public Builder value(TaskStatusValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The unified value for the status of the task. If the provider does not specify this status, the value will be set to UnmappedValue
         */
        public Builder value(JsonNullable<? extends TaskStatusValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(TaskStatusSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends TaskStatusSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public TaskStatus build() {
            return new TaskStatus(
                value,
                sourceValue);
        }
    }
}
