/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.EmailMessagesSourceValue;
import com.stackone.stackone_client_java.models.components.EmailMessagesValue;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class MessageType {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends EmailMessagesValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends EmailMessagesSourceValue> sourceValue;

    @JsonCreator
    public MessageType(@JsonProperty(value="value") JsonNullable<? extends EmailMessagesValue> value, @JsonProperty(value="source_value") JsonNullable<? extends EmailMessagesSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public MessageType() {
        this((JsonNullable<? extends EmailMessagesValue>)JsonNullable.undefined(), (JsonNullable<? extends EmailMessagesSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<EmailMessagesValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<EmailMessagesSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public MessageType withValue(EmailMessagesValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public MessageType withValue(JsonNullable<? extends EmailMessagesValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public MessageType withSourceValue(EmailMessagesSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public MessageType withSourceValue(JsonNullable<? extends EmailMessagesSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageType other = (MessageType)o;
        return Utils.enhancedDeepEquals(this.value, other.value) && Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(MessageType.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends EmailMessagesValue> value = JsonNullable.undefined();
        private JsonNullable<? extends EmailMessagesSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(EmailMessagesValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends EmailMessagesValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(EmailMessagesSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends EmailMessagesSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public MessageType build() {
            return new MessageType(this.value, this.sourceValue);
        }
    }
}

