/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ATSLocationResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsGetLocationResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ATSLocationResult> atsLocationResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsGetLocationResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ATSLocationResult> atsLocationResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(atsLocationResult, "atsLocationResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.atsLocationResult = atsLocationResult;
        this.headers = headers;
    }

    public AtsGetLocationResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ATSLocationResult> atsLocationResult() {
        return this.atsLocationResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsGetLocationResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsGetLocationResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsGetLocationResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsGetLocationResponse withATSLocationResult(ATSLocationResult atsLocationResult) {
        Utils.checkNotNull(atsLocationResult, "atsLocationResult");
        this.atsLocationResult = Optional.ofNullable(atsLocationResult);
        return this;
    }

    public AtsGetLocationResponse withATSLocationResult(Optional<? extends ATSLocationResult> atsLocationResult) {
        Utils.checkNotNull(atsLocationResult, "atsLocationResult");
        this.atsLocationResult = atsLocationResult;
        return this;
    }

    public AtsGetLocationResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsGetLocationResponse other = (AtsGetLocationResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.atsLocationResult, other.atsLocationResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.atsLocationResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsGetLocationResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "atsLocationResult", this.atsLocationResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ATSLocationResult> atsLocationResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder atsLocationResult(ATSLocationResult atsLocationResult) {
            Utils.checkNotNull(atsLocationResult, "atsLocationResult");
            this.atsLocationResult = Optional.ofNullable(atsLocationResult);
            return this;
        }

        public Builder atsLocationResult(Optional<? extends ATSLocationResult> atsLocationResult) {
            Utils.checkNotNull(atsLocationResult, "atsLocationResult");
            this.atsLocationResult = atsLocationResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsGetLocationResponse build() {
            return new AtsGetLocationResponse(this.contentType, this.statusCode, this.rawResponse, this.atsLocationResult, this.headers);
        }
    }
}

