/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HRISCostCenterPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisListCostCenterGroupsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends HRISCostCenterPaginated> hrisCostCenterPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListCostCenterGroupsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends HRISCostCenterPaginated> hrisCostCenterPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisCostCenterPaginated, "hrisCostCenterPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisCostCenterPaginated = hrisCostCenterPaginated;
        this.headers = headers;
    }

    public HrisListCostCenterGroupsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<HRISCostCenterPaginated> hrisCostCenterPaginated() {
        return this.hrisCostCenterPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisListCostCenterGroupsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListCostCenterGroupsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListCostCenterGroupsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListCostCenterGroupsResponse withHRISCostCenterPaginated(HRISCostCenterPaginated hrisCostCenterPaginated) {
        Utils.checkNotNull(hrisCostCenterPaginated, "hrisCostCenterPaginated");
        this.hrisCostCenterPaginated = Optional.ofNullable(hrisCostCenterPaginated);
        return this;
    }

    public HrisListCostCenterGroupsResponse withHRISCostCenterPaginated(Optional<? extends HRISCostCenterPaginated> hrisCostCenterPaginated) {
        Utils.checkNotNull(hrisCostCenterPaginated, "hrisCostCenterPaginated");
        this.hrisCostCenterPaginated = hrisCostCenterPaginated;
        return this;
    }

    public HrisListCostCenterGroupsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListCostCenterGroupsResponse other = (HrisListCostCenterGroupsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.hrisCostCenterPaginated, other.hrisCostCenterPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.hrisCostCenterPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListCostCenterGroupsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "hrisCostCenterPaginated", this.hrisCostCenterPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends HRISCostCenterPaginated> hrisCostCenterPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder hrisCostCenterPaginated(HRISCostCenterPaginated hrisCostCenterPaginated) {
            Utils.checkNotNull(hrisCostCenterPaginated, "hrisCostCenterPaginated");
            this.hrisCostCenterPaginated = Optional.ofNullable(hrisCostCenterPaginated);
            return this;
        }

        public Builder hrisCostCenterPaginated(Optional<? extends HRISCostCenterPaginated> hrisCostCenterPaginated) {
            Utils.checkNotNull(hrisCostCenterPaginated, "hrisCostCenterPaginated");
            this.hrisCostCenterPaginated = hrisCostCenterPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListCostCenterGroupsResponse build() {
            return new HrisListCostCenterGroupsResponse(this.contentType, this.statusCode, this.rawResponse, this.hrisCostCenterPaginated, this.headers);
        }
    }
}

