/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class AccountAddress {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("street_1")
    private JsonNullable<String> street1;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("street_2")
    private JsonNullable<String> street2;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("city")
    private JsonNullable<String> city;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("state")
    private JsonNullable<String> state;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("zip_code")
    private JsonNullable<String> zipCode;

    /**
     * The country code
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("country")
    private JsonNullable<? extends AccountAddressCountry> country;

    /**
     * The location type
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("location_type")
    private JsonNullable<? extends AccountAddressLocationType> locationType;

    @JsonCreator
    public AccountAddress(
            @JsonProperty("street_1") JsonNullable<String> street1,
            @JsonProperty("street_2") JsonNullable<String> street2,
            @JsonProperty("city") JsonNullable<String> city,
            @JsonProperty("state") JsonNullable<String> state,
            @JsonProperty("zip_code") JsonNullable<String> zipCode,
            @JsonProperty("country") JsonNullable<? extends AccountAddressCountry> country,
            @JsonProperty("location_type") JsonNullable<? extends AccountAddressLocationType> locationType) {
        Utils.checkNotNull(street1, "street1");
        Utils.checkNotNull(street2, "street2");
        Utils.checkNotNull(city, "city");
        Utils.checkNotNull(state, "state");
        Utils.checkNotNull(zipCode, "zipCode");
        Utils.checkNotNull(country, "country");
        Utils.checkNotNull(locationType, "locationType");
        this.street1 = street1;
        this.street2 = street2;
        this.city = city;
        this.state = state;
        this.zipCode = zipCode;
        this.country = country;
        this.locationType = locationType;
    }
    
    public AccountAddress() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> street1() {
        return street1;
    }

    @JsonIgnore
    public JsonNullable<String> street2() {
        return street2;
    }

    @JsonIgnore
    public JsonNullable<String> city() {
        return city;
    }

    @JsonIgnore
    public JsonNullable<String> state() {
        return state;
    }

    @JsonIgnore
    public JsonNullable<String> zipCode() {
        return zipCode;
    }

    /**
     * The country code
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountAddressCountry> country() {
        return (JsonNullable<AccountAddressCountry>) country;
    }

    /**
     * The location type
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountAddressLocationType> locationType() {
        return (JsonNullable<AccountAddressLocationType>) locationType;
    }

    public static Builder builder() {
        return new Builder();
    }


    public AccountAddress withStreet1(String street1) {
        Utils.checkNotNull(street1, "street1");
        this.street1 = JsonNullable.of(street1);
        return this;
    }

    public AccountAddress withStreet1(JsonNullable<String> street1) {
        Utils.checkNotNull(street1, "street1");
        this.street1 = street1;
        return this;
    }

    public AccountAddress withStreet2(String street2) {
        Utils.checkNotNull(street2, "street2");
        this.street2 = JsonNullable.of(street2);
        return this;
    }

    public AccountAddress withStreet2(JsonNullable<String> street2) {
        Utils.checkNotNull(street2, "street2");
        this.street2 = street2;
        return this;
    }

    public AccountAddress withCity(String city) {
        Utils.checkNotNull(city, "city");
        this.city = JsonNullable.of(city);
        return this;
    }

    public AccountAddress withCity(JsonNullable<String> city) {
        Utils.checkNotNull(city, "city");
        this.city = city;
        return this;
    }

    public AccountAddress withState(String state) {
        Utils.checkNotNull(state, "state");
        this.state = JsonNullable.of(state);
        return this;
    }

    public AccountAddress withState(JsonNullable<String> state) {
        Utils.checkNotNull(state, "state");
        this.state = state;
        return this;
    }

    public AccountAddress withZipCode(String zipCode) {
        Utils.checkNotNull(zipCode, "zipCode");
        this.zipCode = JsonNullable.of(zipCode);
        return this;
    }

    public AccountAddress withZipCode(JsonNullable<String> zipCode) {
        Utils.checkNotNull(zipCode, "zipCode");
        this.zipCode = zipCode;
        return this;
    }

    /**
     * The country code
     */
    public AccountAddress withCountry(AccountAddressCountry country) {
        Utils.checkNotNull(country, "country");
        this.country = JsonNullable.of(country);
        return this;
    }

    /**
     * The country code
     */
    public AccountAddress withCountry(JsonNullable<? extends AccountAddressCountry> country) {
        Utils.checkNotNull(country, "country");
        this.country = country;
        return this;
    }

    /**
     * The location type
     */
    public AccountAddress withLocationType(AccountAddressLocationType locationType) {
        Utils.checkNotNull(locationType, "locationType");
        this.locationType = JsonNullable.of(locationType);
        return this;
    }

    /**
     * The location type
     */
    public AccountAddress withLocationType(JsonNullable<? extends AccountAddressLocationType> locationType) {
        Utils.checkNotNull(locationType, "locationType");
        this.locationType = locationType;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountAddress other = (AccountAddress) o;
        return 
            Utils.enhancedDeepEquals(this.street1, other.street1) &&
            Utils.enhancedDeepEquals(this.street2, other.street2) &&
            Utils.enhancedDeepEquals(this.city, other.city) &&
            Utils.enhancedDeepEquals(this.state, other.state) &&
            Utils.enhancedDeepEquals(this.zipCode, other.zipCode) &&
            Utils.enhancedDeepEquals(this.country, other.country) &&
            Utils.enhancedDeepEquals(this.locationType, other.locationType);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            street1, street2, city,
            state, zipCode, country,
            locationType);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountAddress.class,
                "street1", street1,
                "street2", street2,
                "city", city,
                "state", state,
                "zipCode", zipCode,
                "country", country,
                "locationType", locationType);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> street1 = JsonNullable.undefined();

        private JsonNullable<String> street2 = JsonNullable.undefined();

        private JsonNullable<String> city = JsonNullable.undefined();

        private JsonNullable<String> state = JsonNullable.undefined();

        private JsonNullable<String> zipCode = JsonNullable.undefined();

        private JsonNullable<? extends AccountAddressCountry> country = JsonNullable.undefined();

        private JsonNullable<? extends AccountAddressLocationType> locationType = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        public Builder street1(String street1) {
            Utils.checkNotNull(street1, "street1");
            this.street1 = JsonNullable.of(street1);
            return this;
        }

        public Builder street1(JsonNullable<String> street1) {
            Utils.checkNotNull(street1, "street1");
            this.street1 = street1;
            return this;
        }


        public Builder street2(String street2) {
            Utils.checkNotNull(street2, "street2");
            this.street2 = JsonNullable.of(street2);
            return this;
        }

        public Builder street2(JsonNullable<String> street2) {
            Utils.checkNotNull(street2, "street2");
            this.street2 = street2;
            return this;
        }


        public Builder city(String city) {
            Utils.checkNotNull(city, "city");
            this.city = JsonNullable.of(city);
            return this;
        }

        public Builder city(JsonNullable<String> city) {
            Utils.checkNotNull(city, "city");
            this.city = city;
            return this;
        }


        public Builder state(String state) {
            Utils.checkNotNull(state, "state");
            this.state = JsonNullable.of(state);
            return this;
        }

        public Builder state(JsonNullable<String> state) {
            Utils.checkNotNull(state, "state");
            this.state = state;
            return this;
        }


        public Builder zipCode(String zipCode) {
            Utils.checkNotNull(zipCode, "zipCode");
            this.zipCode = JsonNullable.of(zipCode);
            return this;
        }

        public Builder zipCode(JsonNullable<String> zipCode) {
            Utils.checkNotNull(zipCode, "zipCode");
            this.zipCode = zipCode;
            return this;
        }


        /**
         * The country code
         */
        public Builder country(AccountAddressCountry country) {
            Utils.checkNotNull(country, "country");
            this.country = JsonNullable.of(country);
            return this;
        }

        /**
         * The country code
         */
        public Builder country(JsonNullable<? extends AccountAddressCountry> country) {
            Utils.checkNotNull(country, "country");
            this.country = country;
            return this;
        }


        /**
         * The location type
         */
        public Builder locationType(AccountAddressLocationType locationType) {
            Utils.checkNotNull(locationType, "locationType");
            this.locationType = JsonNullable.of(locationType);
            return this;
        }

        /**
         * The location type
         */
        public Builder locationType(JsonNullable<? extends AccountAddressLocationType> locationType) {
            Utils.checkNotNull(locationType, "locationType");
            this.locationType = locationType;
            return this;
        }

        public AccountAddress build() {

            return new AccountAddress(
                street1, street2, city,
                state, zipCode, country,
                locationType);
        }

    }
}
