/*
 * Decompiled with CFR 0.152.
 */
package com.staffbase.plugins.sdk.sso;

import com.staffbase.plugins.sdk.sso.SSOData;
import com.staffbase.plugins.sdk.sso.SSOException;
import java.security.Key;
import java.security.interfaces.RSAPublicKey;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

public class SSOFacade {
    private static final Logger logger = LogManager.getLogger(SSOFacade.class);
    public static final String EXPECTED_CLAIM_INSTANCE_ID = "instance_id";
    private JwtConsumer jwtConsumer;

    public static SSOFacade create(RSAPublicKey rsaPublicKey) {
        return new SSOFacade().initialize(rsaPublicKey);
    }

    SSOFacade() {
    }

    SSOFacade initialize(RSAPublicKey rsaPublicKey) {
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing single-sign-on manager SSOFacade. ");
        }
        Objects.requireNonNull(rsaPublicKey);
        AlgorithmConstraints algorithmConstraints = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, new String[]{"RS256"});
        this.jwtConsumer = new JwtConsumerBuilder().setJwsAlgorithmConstraints(algorithmConstraints).setSkipDefaultAudienceValidation().setVerificationKey((Key)rsaPublicKey).setRequireExpirationTime().setRequireNotBefore().setRequireIssuedAt().build();
        return this;
    }

    public SSOData verify(String raw) throws SSOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Attempting to decrypt SSO JWT. [raw=" + raw + "]");
        }
        Objects.requireNonNull(raw);
        try {
            JwtClaims jwtClaims = this.jwtConsumer.process(raw).getJwtClaims();
            String instanceId = (String)jwtClaims.getClaimValue(EXPECTED_CLAIM_INSTANCE_ID, String.class);
            if (instanceId == null || instanceId.isEmpty()) {
                if (logger.isFatalEnabled()) {
                    logger.fatal("Encountered illegal sso attempt. Bad instance_id. [instance_id=" + instanceId + "]");
                }
                throw new SSOException("Missing or malformed instance_id.");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Verification of single-sign-on JWT succeeded. [raw=" + raw + "] [claims=" + jwtClaims + "]");
            }
            return new SSOData(jwtClaims);
        }
        catch (MalformedClaimException malformationException) {
            if (logger.isFatalEnabled()) {
                logger.fatal("Encountered malformed sso attempt.", (Throwable)malformationException);
            }
            throw new SSOException(malformationException.getMessage(), malformationException);
        }
        catch (InvalidJwtException invalidJwtException) {
            if (logger.isFatalEnabled()) {
                logger.fatal("Encountered illegal sso attempt.", (Throwable)invalidJwtException);
            }
            throw new SSOException(invalidJwtException.getMessage(), invalidJwtException);
        }
    }
}

