/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Response;
import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.JsonResponseErrModel;
import com.tencentcloudapi.common.JsonResponseModel;
import com.tencentcloudapi.common.Sign;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.http.HttpConnection;
import com.tencentcloudapi.common.profile.ClientProfile;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

public abstract class AbstractClient {
    public static final int HTTP_RSP_OK = 200;
    public static final String SDK_VERSION = "SDK_JAVA_3.0.11";
    private Credential credential;
    private ClientProfile profile;
    private String endpoint;
    private String region;
    private String path;
    private String sdkVersion;
    private String apiVersion;
    public Gson gson;

    public AbstractClient(String endpoint, String version, Credential credential, String region) {
        this(endpoint, version, credential, region, new ClientProfile());
    }

    public AbstractClient(String endpoint, String version, Credential credential, String region, ClientProfile profile) {
        this.credential = credential;
        this.profile = profile;
        this.endpoint = endpoint;
        this.region = region;
        this.path = "/";
        this.sdkVersion = SDK_VERSION;
        this.apiVersion = version;
        this.gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public void setClientProfile(ClientProfile profile) {
        this.profile = profile;
    }

    public ClientProfile getClientProfile() {
        return this.profile;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public Credential getCredential() {
        return this.credential;
    }

    protected String internalRequest(AbstractModel request, String actionName) throws TencentCloudSDKException {
        Response okRsp = null;
        String endpoint = this.endpoint;
        if (this.profile.getHttpProfile().getEndpoint() != null) {
            endpoint = this.profile.getHttpProfile().getEndpoint();
        }
        HashMap<String, String> param = new HashMap<String, String>();
        request.toMap(param, "");
        String strParam = this.formatRequestData(actionName, param);
        HttpConnection conn = new HttpConnection(this.profile.getHttpProfile().getConnTimeout(), this.profile.getHttpProfile().getReadTimeout(), this.profile.getHttpProfile().getWriteTimeout());
        if (this.profile.getHttpProfile().getReqMethod().equals("GET")) {
            okRsp = conn.getRequest(this.profile.getHttpProfile().getProtocol() + endpoint + this.path + "?" + strParam);
        } else if (this.profile.getHttpProfile().getReqMethod().equals("POST")) {
            okRsp = conn.postRequest(this.profile.getHttpProfile().getProtocol() + endpoint + this.path, strParam);
        } else {
            throw new TencentCloudSDKException("Method only support (GET, POST)");
        }
        if (okRsp.code() != 200) {
            throw new TencentCloudSDKException(okRsp.code() + okRsp.message());
        }
        String strResp = null;
        try {
            strResp = okRsp.body().string();
        }
        catch (IOException e) {
            throw new TencentCloudSDKException(e.getMessage());
        }
        JsonResponseModel errResp = null;
        try {
            Type errType = new TypeToken<JsonResponseModel<JsonResponseErrModel>>(){}.getType();
            errResp = (JsonResponseModel)this.gson.fromJson(strResp, errType);
        }
        catch (JsonSyntaxException e) {
            throw new TencentCloudSDKException(e.getMessage());
        }
        if (((JsonResponseErrModel)errResp.response).error != null) {
            throw new TencentCloudSDKException(((JsonResponseErrModel)errResp.response).error.code + "-" + ((JsonResponseErrModel)errResp.response).error.message, ((JsonResponseErrModel)errResp.response).requestId);
        }
        return strResp;
    }

    private String formatRequestData(String action, Map<String, String> param) throws TencentCloudSDKException {
        param.put("Action", action);
        param.put("RequestClient", this.sdkVersion);
        param.put("Nonce", String.valueOf(Math.abs(new Random().nextInt())));
        param.put("Timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        param.put("Version", this.apiVersion);
        if (this.credential.getSecretId() != null && !this.credential.getSecretId().isEmpty()) {
            param.put("SecretId", this.credential.getSecretId());
        }
        if (this.region != null && !this.region.isEmpty()) {
            param.put("Region", this.region);
        }
        if (this.profile.getSignMethod() != null && !this.profile.getSignMethod().isEmpty()) {
            param.put("SignatureMethod", this.profile.getSignMethod());
        }
        if (this.credential.getToken() != null && !this.credential.getToken().isEmpty()) {
            param.put("Token", this.credential.getToken());
        }
        String endpoint = this.endpoint;
        if (this.profile.getHttpProfile().getEndpoint() != null) {
            endpoint = this.profile.getHttpProfile().getEndpoint();
        }
        String sigInParam = Sign.makeSignPlainText(new TreeMap<String, String>(param), this.profile.getHttpProfile().getReqMethod(), endpoint, this.path);
        String sigOutParam = Sign.sign(this.credential.getSecretKey(), sigInParam, this.profile.getSignMethod());
        String strParam = "";
        try {
            for (Map.Entry<String, String> entry : param.entrySet()) {
                strParam = strParam + URLEncoder.encode(entry.getKey(), "utf-8") + "=" + URLEncoder.encode(entry.getValue(), "utf-8") + "&";
            }
            strParam = strParam + "Signature=" + URLEncoder.encode(sigOutParam, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TencentCloudSDKException(e.getMessage());
        }
        return strParam;
    }
}

