/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common;

import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class Sign {
    private static final String CONTENT_CHARSET = "UTF-8";

    public static String sign(String secretKey, String sigStr, String sigMethod) throws TencentCloudSDKException {
        String sig = null;
        try {
            Mac mac = Mac.getInstance(sigMethod);
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getBytes(CONTENT_CHARSET), mac.getAlgorithm());
            mac.init(secretKeySpec);
            byte[] hash = mac.doFinal(sigStr.getBytes(CONTENT_CHARSET));
            sig = DatatypeConverter.printBase64Binary((byte[])hash);
        }
        catch (Exception e) {
            throw new TencentCloudSDKException(e.getMessage());
        }
        return sig;
    }

    public static String makeSignPlainText(TreeMap<String, String> requestParams, String reqMethod, String host, String path) {
        String retStr = "";
        retStr = retStr + reqMethod;
        retStr = retStr + host;
        retStr = retStr + path;
        retStr = retStr + Sign.buildParamStr(requestParams, reqMethod);
        return retStr;
    }

    protected static String buildParamStr(TreeMap<String, String> requestParams, String requestMethod) {
        String retStr = "";
        for (String key : requestParams.keySet()) {
            String value = requestParams.get(key).toString();
            retStr = retStr.length() == 0 ? retStr + '?' : retStr + '&';
            retStr = retStr + key.replace("_", ".") + '=' + value;
        }
        return retStr;
    }
}

