/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common;

import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class Sign {
    private static final Charset UTF8 = StandardCharsets.UTF_8;

    public static String sign(String secretKey, String sigStr, String sigMethod) throws TencentCloudSDKException {
        String sig = null;
        try {
            Mac mac = Mac.getInstance(sigMethod);
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getBytes(UTF8), mac.getAlgorithm());
            mac.init(secretKeySpec);
            byte[] hash = mac.doFinal(sigStr.getBytes(UTF8));
            sig = DatatypeConverter.printBase64Binary((byte[])hash);
        }
        catch (Exception e) {
            throw new TencentCloudSDKException(e.getMessage());
        }
        return sig;
    }

    public static String makeSignPlainText(TreeMap<String, String> requestParams, String reqMethod, String host, String path) {
        String retStr = "";
        retStr = retStr + reqMethod;
        retStr = retStr + host;
        retStr = retStr + path;
        retStr = retStr + Sign.buildParamStr(requestParams, reqMethod);
        return retStr;
    }

    protected static String buildParamStr(TreeMap<String, String> requestParams, String requestMethod) {
        String retStr = "";
        for (String key : requestParams.keySet()) {
            String value = requestParams.get(key).toString();
            retStr = retStr.length() == 0 ? retStr + '?' : retStr + '&';
            retStr = retStr + key.replace("_", ".") + '=' + value;
        }
        return retStr;
    }

    public static String sha256Hex(String s) throws TencentCloudSDKException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new TencentCloudSDKException("SHA-256 is not supported." + e.getMessage());
        }
        byte[] d = md.digest(s.getBytes(UTF8));
        return DatatypeConverter.printHexBinary((byte[])d).toLowerCase();
    }

    public static byte[] hmac256(byte[] key, String msg) throws TencentCloudSDKException {
        Mac mac;
        try {
            mac = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new TencentCloudSDKException("HmacSHA256 is not supported." + e.getMessage());
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, mac.getAlgorithm());
        try {
            mac.init(secretKeySpec);
        }
        catch (InvalidKeyException e) {
            throw new TencentCloudSDKException(e.getMessage());
        }
        return mac.doFinal(msg.getBytes(UTF8));
    }
}

