/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common.profile;

import com.tencentcloudapi.common.profile.HttpProfile;

public class ClientProfile {
    public static final String SIGN_SHA1 = "HmacSHA1";
    public static final String SIGN_SHA256 = "HmacSHA256";
    public static final String SIGN_TC3_256 = "TC3-HMAC-SHA256";
    private HttpProfile httpProfile;
    private String signMethod;
    private boolean unsignedPayload;

    public ClientProfile(String signMethod, HttpProfile httpProfile) {
        if (signMethod == null || signMethod.isEmpty()) {
            signMethod = SIGN_SHA256;
        }
        this.signMethod = signMethod;
        this.httpProfile = httpProfile;
        this.unsignedPayload = false;
    }

    public ClientProfile(String signMethod) {
        this(signMethod, new HttpProfile());
    }

    public ClientProfile() {
        this(SIGN_SHA256, new HttpProfile());
    }

    public void setSignMethod(String signMethod) {
        this.signMethod = signMethod;
    }

    public void setHttpProfile(HttpProfile httpProfile) {
        this.httpProfile = httpProfile;
    }

    public String getSignMethod() {
        return this.signMethod;
    }

    public HttpProfile getHttpProfile() {
        return this.httpProfile;
    }

    public void setUnsignedPayload(boolean flag) {
        this.unsignedPayload = flag;
    }

    public boolean isUnsignedPayload() {
        return this.unsignedPayload;
    }
}

