/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;

public abstract class AbstractModel {
    protected abstract void toMap(HashMap<String, String> var1, String var2);

    protected String[] getBinaryParams() {
        return new String[0];
    }

    protected <V> void setParamSimple(HashMap<String, String> map, String key, V value) {
        if (value != null) {
            key = key.substring(0, 1).toUpperCase() + key.substring(1);
            key = key.replace("_", ".");
            map.put(key, String.valueOf(value));
        }
    }

    protected <V> void setParamArraySimple(HashMap<String, String> map, String prefix, V[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                this.setParamSimple(map, prefix + i, array[i]);
            }
        }
    }

    protected <V extends AbstractModel> void setParamObj(HashMap<String, String> map, String prefix, V obj) {
        if (obj != null) {
            obj.toMap(map, prefix);
        }
    }

    protected <V extends AbstractModel> void setParamArrayObj(HashMap<String, String> map, String prefix, V[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                this.setParamObj(map, prefix + i + ".", array[i]);
            }
        }
    }

    public static <O extends AbstractModel> String toJsonString(O obj) {
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        return gson.toJson(obj);
    }

    public static <O> O fromJsonString(String json, Class<O> cls) {
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        return (O)gson.fromJson(json, cls);
    }
}

