package com.tencentcloudapi.batch.v20170312.models;
import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;
public class DescribeComputeEnvActivitiesResponse  extends AbstractModel{


    /**
    * 计算环境中的活动列表
    */
    @SerializedName("ActivitySet")
    @Expose
    private Activity [] ActivitySet;

    /**
    * 活动数量
    */
    @SerializedName("TotalCount")
    @Expose
    private Integer TotalCount;

    /**
    * 唯一请求ID，每次请求都会返回。定位问题时需要提供该次请求的RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * 获取计算环境中的活动列表
     * @return ActivitySet 计算环境中的活动列表
     */
    public Activity [] getActivitySet() {
        return this.ActivitySet;
    }

    /**
     * 设置计算环境中的活动列表
     * @param ActivitySet 计算环境中的活动列表
     */
    public void setActivitySet(Activity [] ActivitySet) {
        this.ActivitySet = ActivitySet;
    }

    /**
     * 获取活动数量
     * @return TotalCount 活动数量
     */
    public Integer getTotalCount() {
        return this.TotalCount;
    }

    /**
     * 设置活动数量
     * @param TotalCount 活动数量
     */
    public void setTotalCount(Integer TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * 获取唯一请求ID，每次请求都会返回。定位问题时需要提供该次请求的RequestId。
     * @return RequestId 唯一请求ID，每次请求都会返回。定位问题时需要提供该次请求的RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * 设置唯一请求ID，每次请求都会返回。定位问题时需要提供该次请求的RequestId。
     * @param RequestId 唯一请求ID，每次请求都会返回。定位问题时需要提供该次请求的RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    /**
     * 内部实现，用户禁止调用
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "ActivitySet.", this.ActivitySet);
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

