package com.tencentcloudapi.postgres.v20170312.models;
import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;
public class InitDBInstancesRequest  extends AbstractModel{


    /**
    * 实例ID集合。
    */
    @SerializedName("DBInstanceIdSet")
    @Expose
    private String [] DBInstanceIdSet;

    /**
    * 实例根账号用户名。
    */
    @SerializedName("AdminName")
    @Expose
    private String AdminName;

    /**
    * 实例根账号用户名对应的密码。
    */
    @SerializedName("AdminPassword")
    @Expose
    private String AdminPassword;

    /**
    * 实例字符集，目前只支持：UTF8、LATIN1。
    */
    @SerializedName("Charset")
    @Expose
    private String Charset;

    /**
     * 获取实例ID集合。
     * @return DBInstanceIdSet 实例ID集合。
     */
    public String [] getDBInstanceIdSet() {
        return this.DBInstanceIdSet;
    }

    /**
     * 设置实例ID集合。
     * @param DBInstanceIdSet 实例ID集合。
     */
    public void setDBInstanceIdSet(String [] DBInstanceIdSet) {
        this.DBInstanceIdSet = DBInstanceIdSet;
    }

    /**
     * 获取实例根账号用户名。
     * @return AdminName 实例根账号用户名。
     */
    public String getAdminName() {
        return this.AdminName;
    }

    /**
     * 设置实例根账号用户名。
     * @param AdminName 实例根账号用户名。
     */
    public void setAdminName(String AdminName) {
        this.AdminName = AdminName;
    }

    /**
     * 获取实例根账号用户名对应的密码。
     * @return AdminPassword 实例根账号用户名对应的密码。
     */
    public String getAdminPassword() {
        return this.AdminPassword;
    }

    /**
     * 设置实例根账号用户名对应的密码。
     * @param AdminPassword 实例根账号用户名对应的密码。
     */
    public void setAdminPassword(String AdminPassword) {
        this.AdminPassword = AdminPassword;
    }

    /**
     * 获取实例字符集，目前只支持：UTF8、LATIN1。
     * @return Charset 实例字符集，目前只支持：UTF8、LATIN1。
     */
    public String getCharset() {
        return this.Charset;
    }

    /**
     * 设置实例字符集，目前只支持：UTF8、LATIN1。
     * @param Charset 实例字符集，目前只支持：UTF8、LATIN1。
     */
    public void setCharset(String Charset) {
        this.Charset = Charset;
    }

    /**
     * 内部实现，用户禁止调用
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "DBInstanceIdSet.", this.DBInstanceIdSet);
        this.setParamSimple(map, prefix + "AdminName", this.AdminName);
        this.setParamSimple(map, prefix + "AdminPassword", this.AdminPassword);
        this.setParamSimple(map, prefix + "Charset", this.Charset);

    }
}

