/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.batch.v20170312.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeComputeEnvsResponse extends AbstractModel{

    /**
    * 计算环境列表
    */
    @SerializedName("ComputeEnvSet")
    @Expose
    private ComputeEnvView [] ComputeEnvSet;

    /**
    * 计算环境数量
    */
    @SerializedName("TotalCount")
    @Expose
    private Long TotalCount;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 计算环境列表 
     * @return ComputeEnvSet 计算环境列表
     */
    public ComputeEnvView [] getComputeEnvSet() {
        return this.ComputeEnvSet;
    }

    /**
     * Set 计算环境列表
     * @param ComputeEnvSet 计算环境列表
     */
    public void setComputeEnvSet(ComputeEnvView [] ComputeEnvSet) {
        this.ComputeEnvSet = ComputeEnvSet;
    }

    /**
     * Get 计算环境数量 
     * @return TotalCount 计算环境数量
     */
    public Long getTotalCount() {
        return this.TotalCount;
    }

    /**
     * Set 计算环境数量
     * @param TotalCount 计算环境数量
     */
    public void setTotalCount(Long TotalCount) {
        this.TotalCount = TotalCount;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeComputeEnvsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeComputeEnvsResponse(DescribeComputeEnvsResponse source) {
        if (source.ComputeEnvSet != null) {
            this.ComputeEnvSet = new ComputeEnvView[source.ComputeEnvSet.length];
            for (int i = 0; i < source.ComputeEnvSet.length; i++) {
                this.ComputeEnvSet[i] = new ComputeEnvView(source.ComputeEnvSet[i]);
            }
        }
        if (source.TotalCount != null) {
            this.TotalCount = new Long(source.TotalCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "ComputeEnvSet.", this.ComputeEnvSet);
        this.setParamSimple(map, prefix + "TotalCount", this.TotalCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

