/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.bm.v20180423.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeCustomImageProcessResponse extends AbstractModel{

    /**
    * 镜像制作进度
    */
    @SerializedName("CustomImageProcessSet")
    @Expose
    private CustomImageProcess [] CustomImageProcessSet;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 镜像制作进度 
     * @return CustomImageProcessSet 镜像制作进度
     */
    public CustomImageProcess [] getCustomImageProcessSet() {
        return this.CustomImageProcessSet;
    }

    /**
     * Set 镜像制作进度
     * @param CustomImageProcessSet 镜像制作进度
     */
    public void setCustomImageProcessSet(CustomImageProcess [] CustomImageProcessSet) {
        this.CustomImageProcessSet = CustomImageProcessSet;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeCustomImageProcessResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeCustomImageProcessResponse(DescribeCustomImageProcessResponse source) {
        if (source.CustomImageProcessSet != null) {
            this.CustomImageProcessSet = new CustomImageProcess[source.CustomImageProcessSet.length];
            for (int i = 0; i < source.CustomImageProcessSet.length; i++) {
                this.CustomImageProcessSet[i] = new CustomImageProcess(source.CustomImageProcessSet[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "CustomImageProcessSet.", this.CustomImageProcessSet);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

