/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.ccc.v20200210.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribePSTNActiveSessionListResponse extends AbstractModel{

    /**
    * 列表总条数
    */
    @SerializedName("Total")
    @Expose
    private Long Total;

    /**
    * 列表内容
    */
    @SerializedName("Sessions")
    @Expose
    private PSTNSessionInfo [] Sessions;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 列表总条数 
     * @return Total 列表总条数
     */
    public Long getTotal() {
        return this.Total;
    }

    /**
     * Set 列表总条数
     * @param Total 列表总条数
     */
    public void setTotal(Long Total) {
        this.Total = Total;
    }

    /**
     * Get 列表内容 
     * @return Sessions 列表内容
     */
    public PSTNSessionInfo [] getSessions() {
        return this.Sessions;
    }

    /**
     * Set 列表内容
     * @param Sessions 列表内容
     */
    public void setSessions(PSTNSessionInfo [] Sessions) {
        this.Sessions = Sessions;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribePSTNActiveSessionListResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribePSTNActiveSessionListResponse(DescribePSTNActiveSessionListResponse source) {
        if (source.Total != null) {
            this.Total = new Long(source.Total);
        }
        if (source.Sessions != null) {
            this.Sessions = new PSTNSessionInfo[source.Sessions.length];
            for (int i = 0; i < source.Sessions.length; i++) {
                this.Sessions[i] = new PSTNSessionInfo(source.Sessions[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Total", this.Total);
        this.setParamArrayObj(map, prefix + "Sessions.", this.Sessions);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

