/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tkgdq.v20190411.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeEntityRequest extends AbstractModel{

    /**
    * 实体名称
    */
    @SerializedName("EntityName")
    @Expose
    private String EntityName;

    /**
     * Get 实体名称 
     * @return EntityName 实体名称
     */
    public String getEntityName() {
        return this.EntityName;
    }

    /**
     * Set 实体名称
     * @param EntityName 实体名称
     */
    public void setEntityName(String EntityName) {
        this.EntityName = EntityName;
    }

    public DescribeEntityRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeEntityRequest(DescribeEntityRequest source) {
        if (source.EntityName != null) {
            this.EntityName = new String(source.EntityName);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "EntityName", this.EntityName);

    }
}

